/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.hawkular.AuthenticationOptions;
import io.vertx.ext.hawkular.VertxHawkularOptions;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Sender
implements Handler<List<DataPoint>> {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private static final CharSequence MEDIA_TYPE_APPLICATION_JSON = HttpHeaders.createOptimized("application/json");
    private static final CharSequence HTTP_HEADER_HAWKULAR_TENANT = HttpHeaders.createOptimized("Hawkular-Tenant");
    private final Vertx vertx;
    private final String metricsURI;
    private final CharSequence tenant;
    private final CharSequence auth;
    private final Map<CharSequence, Iterable<CharSequence>> httpHeaders;
    private final int batchSize;
    private final long batchDelay;
    private final List<DataPoint> queue;
    private HttpClient httpClient;
    private long timerId;
    private long sendTime;

    public Sender(Vertx vertx, VertxHawkularOptions options, Context context) {
        JsonObject httpHeaders;
        this.vertx = vertx;
        this.metricsURI = options.getMetricsServiceUri() + "/metrics/data";
        this.tenant = options.isSendTenantHeader() ? HttpHeaders.createOptimized(options.getTenant()) : null;
        AuthenticationOptions authenticationOptions = options.getAuthenticationOptions();
        if (authenticationOptions.isEnabled()) {
            String authString = authenticationOptions.getId() + ":" + authenticationOptions.getSecret();
            try {
                this.auth = HttpHeaders.createOptimized("Basic " + Base64.getEncoder().encodeToString(authString.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.auth = null;
        }
        if ((httpHeaders = options.getHttpHeaders()) != null) {
            this.httpHeaders = new HashMap<CharSequence, Iterable<CharSequence>>(httpHeaders.size());
            for (String headerName : httpHeaders.fieldNames()) {
                CharSequence optimizedName = HttpHeaders.createOptimized(headerName);
                Object value = httpHeaders.getValue(headerName);
                List<String> values = value instanceof JsonArray ? ((JsonArray)value).stream().map(Object::toString).collect(Collectors.toList()) : Collections.singletonList(value.toString());
                this.httpHeaders.put(optimizedName, values.stream().map(HttpHeaders::createOptimized).collect(Collectors.toList()));
            }
        } else {
            this.httpHeaders = Collections.emptyMap();
        }
        this.batchSize = options.getBatchSize();
        this.batchDelay = TimeUnit.NANOSECONDS.convert(options.getBatchDelay(), TimeUnit.SECONDS);
        this.queue = new ArrayList<DataPoint>(this.batchSize);
        context.runOnContext(aVoid -> {
            HttpClientOptions httpClientOptions = options.getHttpOptions().setDefaultHost(options.getHost()).setDefaultPort(options.getPort());
            this.httpClient = vertx.createHttpClient(httpClientOptions);
            this.timerId = vertx.setPeriodic(TimeUnit.MILLISECONDS.convert(this.batchDelay, TimeUnit.NANOSECONDS), this::flushIfIdle);
        });
        this.sendTime = System.nanoTime();
    }

    @Override
    public void handle(List<DataPoint> dataPoints) {
        if (LOG.isTraceEnabled()) {
            String lineSeparator = System.getProperty("line.separator");
            String msg = "Handling data points: " + lineSeparator + dataPoints.stream().map(Object::toString).collect(Collectors.joining(lineSeparator));
            LOG.trace(msg);
        }
        if (this.queue.size() + dataPoints.size() < this.batchSize) {
            this.queue.addAll(dataPoints);
            return;
        }
        ArrayList<DataPoint> temp = new ArrayList<DataPoint>(this.queue.size() + dataPoints.size());
        temp.addAll(this.queue);
        temp.addAll(dataPoints);
        this.queue.clear();
        do {
            List<DataPoint> subList = temp.subList(0, this.batchSize);
            this.send(subList);
            subList.clear();
        } while (temp.size() >= this.batchSize);
        this.queue.addAll(temp);
    }

    private void send(List<DataPoint> dataPoints) {
        JsonObject mixedData = this.toHawkularMixedData(dataPoints);
        HttpClientRequest request = this.httpClient.post(this.metricsURI, this::onResponse).exceptionHandler(err -> LOG.trace((Object)"Could not send metrics", (Throwable)err)).putHeader(HttpHeaders.CONTENT_TYPE, MEDIA_TYPE_APPLICATION_JSON);
        if (this.tenant != null) {
            request.putHeader(HTTP_HEADER_HAWKULAR_TENANT, this.tenant);
        }
        if (this.auth != null) {
            request.putHeader(HttpHeaders.AUTHORIZATION, this.auth);
        }
        this.httpHeaders.entrySet().stream().forEach(httpHeader -> request.putHeader((CharSequence)httpHeader.getKey(), (Iterable)httpHeader.getValue()));
        request.end(mixedData.encode(), "UTF-8");
        this.sendTime = System.nanoTime();
    }

    private JsonObject toHawkularMixedData(List<DataPoint> dataPoints) {
        JsonArray gauges = new JsonArray();
        JsonArray counters = new JsonArray();
        dataPoints.forEach(metric -> {
            JsonObject point;
            if (metric instanceof GaugePoint) {
                GaugePoint gaugePoint = (GaugePoint)metric;
                point = new JsonObject();
                point.put("timestamp", gaugePoint.getTimestamp());
                point.put("value", gaugePoint.getValue());
                JsonObject gauge = new JsonObject();
                gauge.put("id", gaugePoint.getName());
                gauge.put("data", new JsonArray(Collections.singletonList(point)));
                gauges.add(gauge);
            }
            if (metric instanceof CounterPoint) {
                CounterPoint counterPoint = (CounterPoint)metric;
                point = new JsonObject();
                point.put("timestamp", counterPoint.getTimestamp());
                point.put("value", counterPoint.getValue());
                JsonObject counter = new JsonObject();
                counter.put("id", counterPoint.getName());
                counter.put("data", new JsonArray(Collections.singletonList(point)));
                counters.add(counter);
            }
        });
        JsonObject mixedData = new JsonObject();
        if (!gauges.isEmpty()) {
            mixedData.put("gauges", gauges);
        }
        if (!counters.isEmpty()) {
            mixedData.put("counters", counters);
        }
        return mixedData;
    }

    private void onResponse(HttpClientResponse response) {
        if (response.statusCode() != 200 && LOG.isTraceEnabled()) {
            response.bodyHandler(msg -> LOG.trace("Could not send metrics: " + response.statusCode() + " : " + msg.toString()));
        }
    }

    private void flushIfIdle(Long timerId) {
        if (System.nanoTime() - this.sendTime > this.batchDelay && !this.queue.isEmpty()) {
            this.send(this.queue);
            this.queue.clear();
        }
    }

    public void stop() {
        this.vertx.cancelTimer(this.timerId);
        this.httpClient.close();
    }
}

