/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.backend;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.vertx.core.eventbus.EventBus;
import java.util.List;
import org.hawkular.metrics.client.common.SingleMetric;
import org.hawkular.metrics.clients.ptrans.backend.SingleMetricConverter;

@ChannelHandler.Sharable
public class NettyToVertxHandler
extends SimpleChannelInboundHandler<Object> {
    private final EventBus eventBus;

    public NettyToVertxHandler(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object object) throws Exception {
        if (object instanceof SingleMetric) {
            SingleMetric singleMetric = (SingleMetric)object;
            this.eventBus.publish("singlemetric", SingleMetricConverter.toJsonObject(singleMetric));
        } else if (object instanceof List) {
            List objects = (List)object;
            objects.stream().filter(o -> o instanceof SingleMetric).map(o -> (SingleMetric)o).map(SingleMetricConverter::toJsonObject).forEach(jsonObject -> this.eventBus.publish("singlemetric", jsonObject));
        }
    }
}

