/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.event;

import org.hawkular.metrics.clients.ptrans.collectd.event.TimeResolution;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;
import org.hawkular.metrics.clients.ptrans.util.Arguments;

public abstract class Event {
    private final String host;
    private final TimeSpan timestamp;
    private final String pluginName;
    private final String pluginInstance;
    private final String typeName;
    private final String typeInstance;

    protected Event(String host, TimeSpan timestamp, String pluginName, String pluginInstance, String typeName, String typeInstance) {
        Arguments.checkArgument(host != null, "host is null", new Object[0]);
        Arguments.checkArgument(timestamp != null, "timestamp is null", new Object[0]);
        Arguments.checkArgument(pluginName != null, "pluginName is null", new Object[0]);
        Arguments.checkArgument(pluginInstance != null, "pluginInstance is null", new Object[0]);
        Arguments.checkArgument(typeName != null, "typeName is null", new Object[0]);
        Arguments.checkArgument(typeInstance != null, "typeInstance is null", new Object[0]);
        this.host = host;
        this.timestamp = timestamp;
        this.pluginName = pluginName;
        this.pluginInstance = pluginInstance;
        this.typeName = typeName;
        this.typeInstance = typeInstance;
    }

    public final String getHost() {
        return this.host;
    }

    public final TimeSpan getTimestamp() {
        return this.timestamp;
    }

    public final String getPluginName() {
        return this.pluginName;
    }

    public final String getPluginInstance() {
        return this.pluginInstance;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final String getTypeInstance() {
        return this.typeInstance;
    }

    public String toString() {
        return "Event[host='" + this.host + '\'' + ", timestamp=" + TimeResolution.toDate(this.timestamp) + ", pluginName='" + this.pluginName + '\'' + ", pluginInstance='" + this.pluginInstance + '\'' + ", typeName='" + this.typeName + '\'' + ", typeInstance='" + this.typeInstance + '\'' + ']';
    }
}

