/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.commands.metrics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.HystrixCommandGroupKey;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.rx.cdi.WithValues;
import org.hawkular.rx.commands.common.AbstractHttpCommand;
import org.hawkular.rx.commands.common.HawkularConfiguration;
import org.hawkular.rx.httpclient.HttpClient;
import org.hawkular.rx.httpclient.RestResponse;
import rx.Observable;
import rx.Subscriber;

@WithValues
public class CreateMetricCommand
extends AbstractHttpCommand<String> {
    private Metric.Blueprint metric;
    private String authToken;
    private String persona;
    private String resourcePath;
    @Inject
    private HttpClient client;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private HawkularConfiguration config;

    @Override
    protected List<ImmutablePair<Class, Consumer>> getSetters() {
        CreateMetricCommand self = this;
        return Arrays.asList(new ImmutablePair(String.class, x -> {
            self.authToken = this.nullOrStr(x);
        }), new ImmutablePair(String.class, x -> {
            self.persona = this.nullOrStr(x);
        }));
    }

    @Inject
    private CreateMetricCommand(InjectionPoint ip) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"metric-metric"));
        this.initialize(ip);
    }

    protected Observable<String> construct() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> observer) {
                try {
                    String url;
                    if (CreateMetricCommand.this.resourcePath != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        CreateMetricCommand.this.config;
                        url = stringBuilder.append("http://127.0.0.1:8080/hawkular/metrics").append("/test/resources/").append(CreateMetricCommand.this.resourcePath).append("/metrics").toString();
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        CreateMetricCommand.this.config;
                        url = stringBuilder.append("http://127.0.0.1:8080/hawkular/metrics").append("/test/metrics").toString();
                    }
                    RestResponse response = CreateMetricCommand.this.client.post(CreateMetricCommand.this.authToken, CreateMetricCommand.this.persona, url, CreateMetricCommand.this.mapper.writeValueAsString((Object)CreateMetricCommand.this.metric));
                    observer.onNext((Object)response.getLocationHeader());
                    observer.onCompleted();
                }
                catch (Exception e) {
                    observer.onError((Throwable)e);
                }
            }
        });
    }

    public void setMetric(Metric.Blueprint metric) {
        this.metric = metric;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }
}

