/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.AbstractXMLDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;

public class XMLXaDataSourceRuntimeHandler
extends AbstractXMLDataSourceRuntimeHandler<XaDataSource> {
    public static final XMLXaDataSourceRuntimeHandler INSTANCE = new XMLXaDataSourceRuntimeHandler();

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, XaDataSource dataSource, PathAddress address) {
        String target = address.getLastElement().getKey();
        if (target.equals("xa-datasource-properties")) {
            this.handlePropertyAttribute(attributeName, context, dataSource, address.getLastElement().getValue());
        } else if (target.equals("xa-data-source")) {
            this.handleDatasourceAttribute(attributeName, context, dataSource);
        }
    }

    private void handlePropertyAttribute(String attributeName, OperationContext context, XaDataSource dataSource, String propName) {
        if (!attributeName.equals("value")) {
            throw ConnectorLogger.ROOT_LOGGER.unknownAttribute(attributeName);
        }
        this.setStringIfNotNull(context, (String)dataSource.getXaDataSourceProperty().get(propName));
    }

    private void handleDatasourceAttribute(String attributeName, OperationContext context, XaDataSource dataSource) {
        if (attributeName.equals(Constants.XA_DATASOURCE_CLASS.getName())) {
            this.setStringIfNotNull(context, dataSource.getXaDataSourceClass());
        } else if (attributeName.equals(Constants.JNDI_NAME.getName())) {
            this.setStringIfNotNull(context, dataSource.getJndiName());
        } else if (attributeName.equals(Constants.DATASOURCE_DRIVER.getName())) {
            this.setStringIfNotNull(context, dataSource.getDriver());
        } else if (attributeName.equals(Constants.NEW_CONNECTION_SQL.getName())) {
            this.setStringIfNotNull(context, dataSource.getNewConnectionSql());
        } else if (attributeName.equals(Constants.URL_DELIMITER.getName())) {
            this.setStringIfNotNull(context, dataSource.getUrlDelimiter());
        } else if (attributeName.equals(Constants.URL_PROPERTY.getName())) {
            this.setStringIfNotNull(context, dataSource.getUrlProperty());
        } else if (attributeName.equals(Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.getName())) {
            this.setStringIfNotNull(context, dataSource.getUrlSelectorStrategyClassName());
        } else if (attributeName.equals(Constants.USE_JAVA_CONTEXT.getName())) {
            this.setBooleanIfNotNull(context, dataSource.isUseJavaContext());
        } else if (attributeName.equals(Constants.ENABLED.getName())) {
            this.setBooleanIfNotNull(context, dataSource.isEnabled());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getXaPool().getMaxPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getXaPool().getInitialPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getXaPool().getMinPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isPrefill());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isFair());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isUseStrictMin());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            if (dataSource.getXaPool().getFlushStrategy() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getXaPool().getFlushStrategy().getName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.getName())) {
            if (dataSource.getXaPool() == null || dataSource.getXaPool().getCapacity() == null || dataSource.getXaPool().getCapacity().getIncrementer() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getXaPool().getCapacity().getIncrementer().getClassName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.getName())) {
            if (dataSource.getXaPool() == null || dataSource.getXaPool().getCapacity() == null || dataSource.getXaPool().getCapacity().getDecrementer() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getXaPool().getCapacity().getDecrementer().getClassName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.getName())) {
            DsXaPool pool = dataSource.getXaPool();
            if (pool == null || pool.getCapacity() == null || pool.getCapacity().getIncrementer() == null) {
                return;
            }
            Map propertiesMap = pool.getCapacity().getIncrementer().getConfigPropertiesMap();
            if (propertiesMap == null) {
                return;
            }
            for (Map.Entry entry : propertiesMap.entrySet()) {
                context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
            }
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.getName())) {
            DsXaPool pool = dataSource.getXaPool();
            if (pool == null || pool.getCapacity() == null || pool.getCapacity().getDecrementer() == null) {
                return;
            }
            Map propertiesMap = pool.getCapacity().getDecrementer().getConfigPropertiesMap();
            if (propertiesMap == null) {
                return;
            }
            for (Map.Entry entry : propertiesMap.entrySet()) {
                context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
            }
        } else if (attributeName.equals(Constants.INTERLEAVING.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isInterleaving());
        } else if (attributeName.equals(Constants.NO_TX_SEPARATE_POOL.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isNoTxSeparatePool());
        } else if (attributeName.equals(Constants.PAD_XID.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isPadXid());
        } else if (attributeName.equals(Constants.SAME_RM_OVERRIDE.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isSameRmOverride());
        } else if (attributeName.equals(Constants.WRAP_XA_RESOURCE.getName())) {
            if (dataSource.getXaPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getXaPool().isWrapXaResource());
        } else if (attributeName.equals(Constants.PREPARED_STATEMENTS_CACHE_SIZE.getName())) {
            if (dataSource.getStatement() == null) {
                return;
            }
            this.setLongIfNotNull(context, dataSource.getStatement().getPreparedStatementsCacheSize());
        } else if (attributeName.equals(Constants.SHARE_PREPARED_STATEMENTS.getName())) {
            if (dataSource.getStatement() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getStatement().isSharePreparedStatements());
        } else if (attributeName.equals(Constants.TRACK_STATEMENTS.getName())) {
            if (dataSource.getStatement() == null) {
                return;
            }
            if (dataSource.getStatement().getTrackStatements() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getStatement().getTrackStatements().name());
        } else if (attributeName.equals(Constants.ALLOCATION_RETRY.getName())) {
            if (dataSource.getTimeOut() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getTimeOut().getAllocationRetry());
        } else if (attributeName.equals(Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName())) {
            if (dataSource.getTimeOut() == null) {
                return;
            }
            this.setLongIfNotNull(context, dataSource.getTimeOut().getAllocationRetryWaitMillis());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName())) {
            if (dataSource.getTimeOut() == null) {
                return;
            }
            this.setLongIfNotNull(context, dataSource.getTimeOut().getBlockingTimeoutMillis());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.getName())) {
            if (dataSource.getTimeOut() == null) {
                return;
            }
            this.setLongIfNotNull(context, dataSource.getTimeOut().getIdleTimeoutMinutes());
        } else if (attributeName.equals(Constants.XA_RESOURCE_TIMEOUT.getName())) {
            if (dataSource.getTimeOut() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getTimeOut().getXaResourceTimeout());
        } else if (attributeName.equals(Constants.RECOVERY_USERNAME.getName())) {
            if (dataSource.getRecovery() == null) {
                return;
            }
            if (dataSource.getRecovery().getCredential() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getRecovery().getCredential().getUserName());
        } else if (!attributeName.equals(Constants.RECOVERY_PASSWORD.getName())) {
            if (attributeName.equals(Constants.RECOVERY_SECURITY_DOMAIN.getName())) {
                if (dataSource.getRecovery() == null) {
                    return;
                }
                if (dataSource.getRecovery().getCredential() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getRecovery().getCredential().getSecurityDomain());
            } else if (attributeName.equals(Constants.RECOVER_PLUGIN_CLASSNAME.getName())) {
                if (dataSource.getRecovery() == null) {
                    return;
                }
                if (dataSource.getRecovery().getRecoverPlugin() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getRecovery().getRecoverPlugin().getClassName());
            } else if (attributeName.equals(Constants.RECOVER_PLUGIN_PROPERTIES.getName())) {
                if (dataSource.getRecovery() == null) {
                    return;
                }
                if (dataSource.getRecovery().getRecoverPlugin() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getRecovery().getRecoverPlugin().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.NO_RECOVERY.getName())) {
                if (dataSource.getRecovery() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getRecovery().getNoRecovery());
            } else if (attributeName.equals(Constants.CHECK_VALID_CONNECTION_SQL.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getCheckValidConnectionSql());
            } else if (attributeName.equals(Constants.EXCEPTION_SORTER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getExceptionSorter() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getExceptionSorter().getClassName());
            } else if (attributeName.equals(Constants.EXCEPTION_SORTER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getExceptionSorter() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getExceptionSorter().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getStaleConnectionChecker() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getStaleConnectionChecker().getClassName());
            } else if (attributeName.equals(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getStaleConnectionChecker() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getStaleConnectionChecker().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getValidConnectionChecker() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getValidConnectionChecker().getClassName());
            } else if (attributeName.equals(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getValidConnectionChecker() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getValidConnectionChecker().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getValidation().getBackgroundValidationMillis());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isBackgroundValidation());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isUseFastFail());
            } else if (attributeName.equals(Constants.VALIDATE_ON_MATCH.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isValidateOnMatch());
            } else if (attributeName.equals(Constants.USERNAME.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getSecurity().getUserName());
            } else if (!attributeName.equals(Constants.PASSWORD.getName())) {
                if (attributeName.equals(Constants.SECURITY_DOMAIN.getName())) {
                    if (dataSource.getSecurity() == null) {
                        return;
                    }
                    this.setStringIfNotNull(context, dataSource.getSecurity().getSecurityDomain());
                } else if (attributeName.equals(Constants.REAUTH_PLUGIN_CLASSNAME.getName())) {
                    if (dataSource.getSecurity() == null) {
                        return;
                    }
                    if (dataSource.getSecurity().getReauthPlugin() == null) {
                        return;
                    }
                    this.setStringIfNotNull(context, dataSource.getSecurity().getReauthPlugin().getClassName());
                } else if (attributeName.equals(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                    if (dataSource.getSecurity() == null) {
                        return;
                    }
                    if (dataSource.getSecurity().getReauthPlugin() == null) {
                        return;
                    }
                    Map propertiesMap = dataSource.getSecurity().getReauthPlugin().getConfigPropertiesMap();
                    if (propertiesMap == null) {
                        return;
                    }
                    for (Map.Entry entry : propertiesMap.entrySet()) {
                        context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                    }
                } else if (attributeName.equals(Constants.PREPARED_STATEMENTS_CACHE_SIZE.getName())) {
                    if (dataSource.getStatement() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getStatement().getPreparedStatementsCacheSize());
                } else if (attributeName.equals(Constants.SHARE_PREPARED_STATEMENTS.getName())) {
                    if (dataSource.getStatement() == null) {
                        return;
                    }
                    this.setBooleanIfNotNull(context, dataSource.getStatement().isSharePreparedStatements());
                } else if (attributeName.equals(Constants.TRACK_STATEMENTS.getName())) {
                    if (dataSource.getStatement() == null) {
                        return;
                    }
                    if (dataSource.getStatement().getTrackStatements() == null) {
                        return;
                    }
                    this.setStringIfNotNull(context, dataSource.getStatement().getTrackStatements().name());
                } else if (attributeName.equals(Constants.ALLOCATION_RETRY.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setIntIfNotNull(context, dataSource.getTimeOut().getAllocationRetry());
                } else if (attributeName.equals(Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getTimeOut().getAllocationRetryWaitMillis());
                } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getTimeOut().getBlockingTimeoutMillis());
                } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getTimeOut().getIdleTimeoutMinutes());
                } else if (attributeName.equals(Constants.QUERY_TIMEOUT.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getTimeOut().getQueryTimeout());
                } else if (attributeName.equals(Constants.USE_TRY_LOCK.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setLongIfNotNull(context, dataSource.getTimeOut().getUseTryLock());
                } else if (attributeName.equals(Constants.SET_TX_QUERY_TIMEOUT.getName())) {
                    if (dataSource.getTimeOut() == null) {
                        return;
                    }
                    this.setBooleanIfNotNull(context, dataSource.getTimeOut().isSetTxQueryTimeout());
                } else if (attributeName.equals(Constants.TRANSACTION_ISOLATION.getName())) {
                    if (dataSource.getTransactionIsolation() == null) {
                        return;
                    }
                    this.setStringIfNotNull(context, dataSource.getTransactionIsolation().name());
                } else if (attributeName.equals(Constants.SPY.getName())) {
                    this.setBooleanIfNotNull(context, dataSource.isSpy());
                } else if (attributeName.equals(Constants.USE_CCM.getName())) {
                    this.setBooleanIfNotNull(context, dataSource.isUseCcm());
                } else if (attributeName.equals(Constants.JTA.getName())) {
                    this.setBooleanIfNotNull(context, true);
                } else if (attributeName.equals(Constants.ALLOW_MULTIPLE_USERS.getName())) {
                    DsXaPool pool = dataSource.getXaPool();
                    if (!(pool instanceof DsXaPool)) {
                        return;
                    }
                    this.setBooleanIfNotNull(context, pool.isAllowMultipleUsers());
                } else if (attributeName.equals(Constants.CONNECTION_LISTENER_CLASS.getName())) {
                    DsXaPool pool = dataSource.getXaPool();
                    if (!(pool instanceof DsXaPool) || pool.getConnectionListener() == null) {
                        return;
                    }
                    this.setStringIfNotNull(context, pool.getConnectionListener().getClassName());
                } else if (attributeName.equals(Constants.CONNECTION_LISTENER_PROPERTIES.getName())) {
                    DsXaPool pool = dataSource.getXaPool();
                    if (!(pool instanceof DsXaPool) || pool.getConnectionListener() == null) {
                        return;
                    }
                    Map propertiesMap = pool.getConnectionListener().getConfigPropertiesMap();
                    if (propertiesMap == null) {
                        return;
                    }
                    for (Map.Entry entry : propertiesMap.entrySet()) {
                        context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                    }
                } else if (attributeName.equals(Constants.CONNECTABLE.getName())) {
                    context.getResult().set(false);
                } else if (attributeName.equals(Constants.STATISTICS_ENABLED.getName())) {
                    context.getResult().set(false);
                } else {
                    if (attributeName.equals(Constants.TRACKING.getName())) {
                        return;
                    }
                    if (attributeName.equals(Constants.MCP.getName())) {
                        return;
                    }
                    if (attributeName.equals(Constants.ENLISTMENT_TRACE.getName())) {
                        return;
                    }
                    throw ConnectorLogger.ROOT_LOGGER.unknownAttribute(attributeName);
                }
            }
        }
    }
}

