/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.spec;

import org.cryptacular.codec.Base64Codec;
import org.cryptacular.codec.Codec;
import org.cryptacular.codec.HexCodec;
import org.cryptacular.spec.Spec;

public class CodecSpec
implements Spec<Codec> {
    public static final CodecSpec HEX = new CodecSpec("Hex");
    public static final CodecSpec BASE64 = new CodecSpec("Base64");
    private String encoding;

    public CodecSpec(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding cannot be null.");
        }
        this.encoding = encoding;
    }

    @Override
    public String getAlgorithm() {
        return this.encoding;
    }

    @Override
    public Codec newInstance() {
        Codec codec;
        if ("Hex".equalsIgnoreCase(this.encoding)) {
            codec = new HexCodec();
        } else if ("Base64".equalsIgnoreCase(this.encoding) || "Base-64".equalsIgnoreCase(this.encoding)) {
            codec = new Base64Codec();
        } else {
            throw new IllegalArgumentException("Invalid encoding.");
        }
        return codec;
    }

    public String toString() {
        return this.encoding;
    }
}

