/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import java.net.URI;

public class Endpoint {
    public static final Endpoint TEMPORARY_QUEUE = new Endpoint(Type.QUEUE, "__tmpQueue__", true);
    public static final Endpoint TEMPORARY_TOPIC = new Endpoint(Type.TOPIC, "__tmpTopic__", true);
    private final Type type;
    private final String name;
    private final boolean isTemp;

    public Endpoint(String destination) throws IllegalArgumentException {
        Type type;
        URI uri;
        if (destination == null) {
            throw new IllegalArgumentException("destination must not be null");
        }
        try {
            uri = new URI(destination);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid destination URI: " + destination);
        }
        String typeStr = uri.getScheme().toUpperCase();
        try {
            type = Type.valueOf(typeStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid destination URI [" + destination + "]; the endpoint type must be either QUEUE or TOPIC: " + typeStr);
        }
        String name = uri.getHost();
        this.type = type;
        this.name = name;
        this.isTemp = false;
    }

    public Endpoint(Type type, String name) {
        this(type, name, false);
    }

    public Endpoint(Type type, String name, boolean isTemp) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.type = type;
        this.name = name;
        this.isTemp = isTemp;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.isTemp;
    }

    public String toString() {
        if (this.isTemporary()) {
            return "{" + this.type.name() + "}$TEMPORARY$";
        }
        return "{" + this.type.name() + "}" + this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.isTemp ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.type != other.type) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.isTemp == other.isTemp;
    }

    public static enum Type {
        QUEUE,
        TOPIC;

    }
}

