/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.paging.Order;

public class PageContext {
    public static final int UNLIMITED_PAGE_SIZE = -1;
    private final int pageSize;
    private final int pageNumber;
    private final List<Order> order;

    public PageContext(int pageNumber, int pageSize, Order ... orders) {
        if (orders.length == 0) {
            throw new IllegalArgumentException("At least one order specification must be supplied.");
        }
        this.pageNumber = pageSize >= 0 ? pageNumber : 0;
        this.pageSize = pageSize;
        ArrayList tmp = new ArrayList();
        Collections.addAll(tmp, orders);
        this.order = Collections.unmodifiableList(tmp);
    }

    public PageContext(int pageNumber, int pageSize, Iterable<Order> orders) {
        this.pageNumber = pageSize >= 0 ? pageNumber : 0;
        this.pageSize = pageSize;
        ArrayList tmp = new ArrayList();
        orders.forEach(tmp::add);
        if (tmp.size() == 0) {
            throw new IllegalArgumentException("At least one order specification must be supplied.");
        }
        this.order = Collections.unmodifiableList(tmp);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getStart() {
        return this.pageNumber * this.pageSize;
    }

    public int getEnd() {
        if (this.isLimited()) {
            return this.getStart() + this.pageSize;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isLimited() {
        return this.pageSize >= 0;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageContext)) {
            return false;
        }
        PageContext that = (PageContext)o;
        return this.pageSize == that.pageSize && this.pageNumber == that.pageNumber && this.order.equals(that.order);
    }

    public int hashCode() {
        int result = this.pageSize;
        result = 31 * result + this.pageNumber;
        return result;
    }

    public String toString() {
        return "PagingState[order=" + this.order + ", pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ']';
    }
}

