/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;

class Util {
    private static final CacheValue nullTcclFactory = new CacheValue();
    private static final ConcurrentMap<CacheKey, CacheValue> factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();

    Util() {
    }

    static String message(ELContext context, String name, Object ... props) {
        Locale locale = null;
        if (context != null) {
            locale = context.getLocale();
        }
        if (locale == null && (locale = Locale.getDefault()) == null) {
            return "";
        }
        ResourceBundle bundle = ResourceBundle.getBundle("javax.el.PrivateMessages", locale);
        try {
            String template = bundle.getString(name);
            if (props != null) {
                template = MessageFormat.format(template, props);
            }
            return template;
        }
        catch (MissingResourceException e) {
            return "Missing Resource: '" + name + "' for Locale " + locale.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExpressionFactory getExpressionFactory() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        CacheValue cacheValue = null;
        ExpressionFactory factory = null;
        if (tccl == null) {
            cacheValue = nullTcclFactory;
        } else {
            CacheValue newCacheValue;
            CacheKey key = new CacheKey(tccl);
            cacheValue = (CacheValue)factoryCache.get(key);
            if (cacheValue == null && (cacheValue = factoryCache.putIfAbsent(key, newCacheValue = new CacheValue())) == null) {
                cacheValue = newCacheValue;
            }
        }
        Lock readLock = cacheValue.getLock().readLock();
        readLock.lock();
        try {
            factory = cacheValue.getExpressionFactory();
        }
        finally {
            readLock.unlock();
        }
        if (factory == null) {
            Lock writeLock = cacheValue.getLock().writeLock();
            writeLock.lock();
            try {
                factory = cacheValue.getExpressionFactory();
                if (factory == null) {
                    factory = ExpressionFactory.newInstance();
                    cacheValue.setExpressionFactory(factory);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return factory;
    }

    static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        Method[] methods;
        List<Wrapper> wrappers;
        Wrapper result;
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        if ((result = Util.findWrapper(clazz, wrappers = Wrapper.wrap(methods = clazz.getMethods(), methodName), methodName, paramTypes, paramValues)) == null) {
            return null;
        }
        return Util.getMethod(clazz, (Method)result.unWrap());
    }

    private static Wrapper findWrapper(Class<?> clazz, List<Wrapper> wrappers, String name, Class<?>[] paramTypes, Object[] paramValues) {
        HashMap<Wrapper, Integer> candidates = new HashMap<Wrapper, Integer>();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        for (Wrapper w : wrappers) {
            Class<?>[] mParamTypes = w.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (paramCount != mParamCount && (!w.isVarArgs() || paramCount < mParamCount)) continue;
            int exactMatch = 0;
            boolean noMatch = false;
            block1: for (int i = 0; i < mParamCount; ++i) {
                if (mParamTypes[i].equals(paramTypes[i])) {
                    ++exactMatch;
                    continue;
                }
                if (i == mParamCount - 1 && w.isVarArgs()) {
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount; ++j) {
                        if (Util.isAssignableFrom(paramTypes[j], varType)) continue;
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (Util.isCoercibleFrom(paramValues[j], varType)) continue;
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (Util.isAssignableFrom(paramTypes[i], mParamTypes[i])) continue;
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (Util.isCoercibleFrom(paramValues[i], mParamTypes[i])) continue;
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return w;
            }
            candidates.put(w, exactMatch);
        }
        int bestMatch = 0;
        Wrapper match = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            if ((Integer)entry.getValue() > bestMatch || match == null) {
                bestMatch = (Integer)entry.getValue();
                match = (Wrapper)entry.getKey();
                multiple = false;
                continue;
            }
            if ((Integer)entry.getValue() != bestMatch) continue;
            multiple = true;
        }
        if (multiple && (match = bestMatch == paramCount - 1 ? Util.resolveAmbiguousWrapper(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.ambiguous", clazz, name, Util.paramString(paramTypes)));
        }
        if (match == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, name, Util.paramString(paramTypes)));
        }
        return match;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static Wrapper resolveAmbiguousWrapper(Set<Wrapper> candidates, Class<?>[] paramTypes) {
        Wrapper w = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (w.getParameterTypes()[i] == paramTypes[i]) continue;
            nonMatchIndex = i;
            nonMatchClass = paramTypes[i];
            break;
        }
        for (Wrapper c : candidates) {
            if (c.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        if (nonMatchClass == null) {
            Class<?> mostGeneralType = null;
            Wrapper mostGeneralMethod = null;
            boolean generalMatchFound = false;
            for (Wrapper c : candidates) {
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (mostGeneralType == null) {
                    mostGeneralType = candidateType;
                    mostGeneralMethod = c;
                    continue;
                }
                if (candidateType.isAssignableFrom(mostGeneralType)) {
                    mostGeneralType = candidateType;
                    mostGeneralMethod = c;
                    generalMatchFound = true;
                    continue;
                }
                if (!mostGeneralType.isAssignableFrom(candidateType)) continue;
                generalMatchFound = true;
            }
            if (generalMatchFound) {
                return mostGeneralMethod;
            }
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Wrapper c : candidates) {
                if (!c.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return c;
            }
        }
        Wrapper match = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Wrapper c : candidates) {
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (match == null) {
                    match = c;
                    continue;
                }
                match = null;
                break;
            }
        }
        return match;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target) {
        try {
            Util.getExpressionFactory().coerceToType(src, target);
        }
        catch (ELException e) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> findConstructor(Class<?> clazz, Class<?>[] paramTypes, Object[] paramValues) {
        Constructor<?>[] constructors;
        List<Wrapper> wrappers;
        Wrapper result;
        String methodName = "<init>";
        if (clazz == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        if ((result = Util.findWrapper(clazz, wrappers = Wrapper.wrap(constructors = clazz.getConstructors()), methodName, paramTypes, paramValues)) == null) {
            return null;
        }
        return Util.getConstructor(clazz, (Constructor)result.unWrap());
    }

    static Constructor<?> getConstructor(Class<?> type, Constructor<?> c) {
        if (c == null || Modifier.isPublic(type.getModifiers())) {
            return c;
        }
        Constructor<?> cp = null;
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                cp = sup.getConstructor(c.getParameterTypes());
                cp = Util.getConstructor(cp.getDeclaringClass(), cp);
                if (cp != null) {
                    return cp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    static Object[] buildParameters(Class<?>[] parameterTypes, boolean isVarArgs, Object[] params) {
        ExpressionFactory factory = Util.getExpressionFactory();
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            parameters = new Object[parameterTypes.length];
            int paramCount = params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex; ++i) {
                    parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                for (int i = varArgIndex; i < paramCount; ++i) {
                    Array.set(varargs, i - varArgIndex, factory.coerceToType(params[i], varArgClass));
                }
                parameters[varArgIndex] = varargs;
            } else {
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                }
            }
        }
        return parameters;
    }

    private static class ConstructorWrapper
    extends Wrapper {
        private final Constructor<?> c;

        public ConstructorWrapper(Constructor<?> c) {
            this.c = c;
        }

        @Override
        public Object unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }
    }

    private static class MethodWrapper
    extends Wrapper {
        private final Method m;

        public MethodWrapper(Method m) {
            this.m = m;
        }

        @Override
        public Object unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }
    }

    private static abstract class Wrapper {
        private Wrapper() {
        }

        public static List<Wrapper> wrap(Method[] methods, String name) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Method method : methods) {
                if (!method.getName().equals(name) || method.isBridge()) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public static List<Wrapper> wrap(Constructor<?>[] constructors) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Constructor<?> constructor : constructors) {
                result.add(new ConstructorWrapper(constructor));
            }
            return result;
        }

        public abstract Object unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private WeakReference<ExpressionFactory> ref;

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public ExpressionFactory getExpressionFactory() {
            return this.ref != null ? (ExpressionFactory)this.ref.get() : null;
        }

        public void setExpressionFactory(ExpressionFactory factory) {
            this.ref = new WeakReference<ExpressionFactory>(factory);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        public CacheKey(ClassLoader key) {
            this.hash = key.hashCode();
            this.ref = new WeakReference<ClassLoader>(key);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            ClassLoader thisKey = (ClassLoader)this.ref.get();
            if (thisKey == null) {
                return false;
            }
            return thisKey == ((CacheKey)obj).ref.get();
        }
    }
}

