/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Instance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.Name;

public final class MeasurementInstance<L, T extends MeasurementType<L>>
extends Instance<L, T> {
    private static final String METRIC_ID_PROPERTY = "metric-id";

    public MeasurementInstance(ID id, Name name, AttributeLocation<L> attributeLocation, T type) {
        super(id, name, attributeLocation, type);
    }

    public MeasurementInstance(MeasurementInstance<L, T> copy, boolean disown) {
        super(copy, disown);
        if (copy.getProperties().containsKey(METRIC_ID_PROPERTY)) {
            this.addProperty(METRIC_ID_PROPERTY, copy.getProperties().get(METRIC_ID_PROPERTY));
        }
    }

    public String getAssociatedMetricId() {
        Object property = this.getProperties().get(METRIC_ID_PROPERTY);
        if (property != null) {
            return property.toString();
        }
        return this.getID().getIDString();
    }

    public void setAssociatedMetricId(String metricId) {
        if (metricId == null || metricId.isEmpty() || metricId.equals(this.getID().getIDString())) {
            this.removeProperty(METRIC_ID_PROPERTY);
        } else {
            this.addProperty(METRIC_ID_PROPERTY, metricId);
        }
    }
}

