/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.ModuleIdentifier;

public class GlobalModulesDefinition {
    public static final String NAME = "name";
    public static final String SLOT = "slot";
    public static final String ANNOTATIONS = "annotations";
    public static final String META_INF = "meta-inf";
    public static final String SERVICES = "services";
    public static final String GLOBAL_MODULES = "global-modules";
    public static final String DEFAULT_SLOT = "main";
    public static final SimpleAttributeDefinition NAME_AD = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).build();
    public static final SimpleAttributeDefinition SLOT_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("slot", ModelType.STRING, true).setDefaultValue(new ModelNode("main"))).build();
    public static final SimpleAttributeDefinition ANNOTATIONS_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("annotations", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition SERVICES_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("services", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition META_INF_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("meta-inf", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    private static final SimpleAttributeDefinition[] VALUE_TYPE_FIELDS = new SimpleAttributeDefinition[]{NAME_AD, SLOT_AD, ANNOTATIONS_AD, SERVICES_AD, META_INF_AD};
    private static final AttributeMarshaller VALUE_TYPE_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.isDefined()) {
                writer.writeEmptyElement(attribute.getXmlName());
                for (SimpleAttributeDefinition valueType : VALUE_TYPE_FIELDS) {
                    valueType.marshallAsAttribute(resourceModel, writer);
                }
            }
        }
    };
    private static final ObjectTypeAttributeDefinition VALUE_TYPE_AD = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"module", (AttributeDefinition[])VALUE_TYPE_FIELDS).setAttributeMarshaller(VALUE_TYPE_MARSHALLER)).build();
    public static final AttributeDefinition INSTANCE = ObjectListAttributeDefinition.Builder.of((String)"global-modules", (ObjectTypeAttributeDefinition)VALUE_TYPE_AD).setAllowNull(true).build();

    public static List<GlobalModule> createModuleList(OperationContext context, ModelNode globalMods) throws OperationFailedException {
        ArrayList<GlobalModule> ret = new ArrayList<GlobalModule>();
        if (globalMods.isDefined()) {
            for (ModelNode module : globalMods.asList()) {
                String name = NAME_AD.resolveModelAttribute(context, module).asString();
                String slot = SLOT_AD.resolveModelAttribute(context, module).asString();
                boolean annotations = ANNOTATIONS_AD.resolveModelAttribute(context, module).asBoolean();
                boolean services = SERVICES_AD.resolveModelAttribute(context, module).asBoolean();
                boolean metaInf = META_INF_AD.resolveModelAttribute(context, module).asBoolean();
                ret.add(new GlobalModule(ModuleIdentifier.create((String)name, (String)slot), annotations, services, metaInf));
            }
        }
        return ret;
    }

    public static final class GlobalModule {
        private final ModuleIdentifier moduleIdentifier;
        private final boolean annotations;
        private final boolean services;
        private final boolean metaInf;

        GlobalModule(ModuleIdentifier moduleIdentifier, boolean annotations, boolean services, boolean metaInf) {
            this.moduleIdentifier = moduleIdentifier;
            this.annotations = annotations;
            this.services = services;
            this.metaInf = metaInf;
        }

        public ModuleIdentifier getModuleIdentifier() {
            return this.moduleIdentifier;
        }

        public boolean isAnnotations() {
            return this.annotations;
        }

        public boolean isServices() {
            return this.services;
        }

        public boolean isMetaInf() {
            return this.metaInf;
        }
    }
}

