/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.jmx.MBeanRegistrationService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.service.CreateDestroyService;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.ServiceNameFactory;
import org.jboss.as.service.StartStopService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;

final class MBeanServices {
    private static final String CREATE_METHOD_NAME = "create";
    private static final String DESTROY_METHOD_NAME = "destroy";
    private static final String START_METHOD_NAME = "start";
    private static final String STOP_METHOD_NAME = "stop";
    private static final Class<?>[] NO_ARGS = new Class[0];
    private final String mBeanName;
    private final ServiceName createDestroyServiceName;
    private final ServiceName startStopServiceName;
    private final Service<Object> createDestroyService;
    private final Service<Object> startStopService;
    private final ServiceBuilder<?> createDestroyServiceBuilder;
    private final ServiceBuilder<?> startStopServiceBuilder;
    private final ServiceTarget target;
    private final ServiceName mbeanServerServiceName;
    private boolean installed;
    private final List<SetupAction> setupActions;

    MBeanServices(String mBeanName, Object mBeanInstance, List<ClassReflectionIndex> mBeanClassHierarchy, ServiceTarget target, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader, ServiceName mbeanServerServiceName) {
        if (mBeanClassHierarchy == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mBeanName");
        }
        if (mBeanInstance == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mBeanInstance");
        }
        if (target == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("target");
        }
        if (mbeanServerServiceName == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mbeanServerServiceName");
        }
        Method createMethod = ReflectionUtils.getMethod(mBeanClassHierarchy, CREATE_METHOD_NAME, NO_ARGS, false);
        Method destroyMethod = ReflectionUtils.getMethod(mBeanClassHierarchy, DESTROY_METHOD_NAME, NO_ARGS, false);
        this.createDestroyService = new CreateDestroyService(mBeanInstance, createMethod, destroyMethod, componentInstantiator, setupActions, mbeanContextClassLoader);
        this.createDestroyServiceName = ServiceNameFactory.newCreateDestroy(mBeanName);
        this.createDestroyServiceBuilder = target.addService(this.createDestroyServiceName, this.createDestroyService);
        Services.addServerExecutorDependency(this.createDestroyServiceBuilder, ((CreateDestroyService)this.createDestroyService).getExecutorInjector(), (boolean)false);
        if (componentInstantiator != null) {
            this.createDestroyServiceBuilder.addDependency(componentInstantiator.getComponentStartServiceName());
        }
        Method startMethod = ReflectionUtils.getMethod(mBeanClassHierarchy, START_METHOD_NAME, NO_ARGS, false);
        Method stopMethod = ReflectionUtils.getMethod(mBeanClassHierarchy, STOP_METHOD_NAME, NO_ARGS, false);
        this.startStopService = new StartStopService(mBeanInstance, startMethod, stopMethod, setupActions, mbeanContextClassLoader);
        this.startStopServiceName = ServiceNameFactory.newStartStop(mBeanName);
        this.startStopServiceBuilder = target.addService(this.startStopServiceName, this.startStopService);
        this.startStopServiceBuilder.addDependency(this.createDestroyServiceName);
        for (SetupAction action : setupActions) {
            this.startStopServiceBuilder.addDependencies((Iterable)action.dependencies());
        }
        Services.addServerExecutorDependency(this.startStopServiceBuilder, ((StartStopService)this.startStopService).getExecutorInjector(), (boolean)false);
        this.mBeanName = mBeanName;
        this.target = target;
        this.setupActions = setupActions;
        this.mbeanServerServiceName = mbeanServerServiceName;
    }

    Service<Object> getCreateDestroyService() {
        this.assertState();
        return this.createDestroyService;
    }

    Service<Object> getStartStopService() {
        this.assertState();
        return this.startStopService;
    }

    void addDependency(String dependencyMBeanName) {
        this.assertState();
        ServiceName injectedMBeanCreateDestroyServiceName = ServiceNameFactory.newCreateDestroy(dependencyMBeanName);
        this.createDestroyServiceBuilder.addDependency(injectedMBeanCreateDestroyServiceName);
        ServiceName injectedMBeanStartStopServiceName = ServiceNameFactory.newStartStop(dependencyMBeanName);
        this.startStopServiceBuilder.addDependency(injectedMBeanStartStopServiceName);
    }

    void addAttribute(String attributeMBeanName, Injector<Object> injector) {
        this.assertState();
        ServiceName injectedMBeanCreateDestroyServiceName = ServiceNameFactory.newCreateDestroy(attributeMBeanName);
        this.createDestroyServiceBuilder.addDependency(injectedMBeanCreateDestroyServiceName, injector);
        ServiceName injectedMBeanStartStopServiceName = ServiceNameFactory.newStartStop(attributeMBeanName);
        this.startStopServiceBuilder.addDependency(injectedMBeanStartStopServiceName);
    }

    void addInjectionValue(Injector<Object> injector, Value<?> value) {
        this.assertState();
        this.createDestroyServiceBuilder.addInjectionValue(injector, value);
    }

    void install() {
        this.assertState();
        this.createDestroyServiceBuilder.install();
        this.startStopServiceBuilder.install();
        MBeanRegistrationService mbeanRegistrationService = new MBeanRegistrationService(this.mBeanName, this.setupActions);
        this.target.addService(MBeanRegistrationService.SERVICE_NAME.append(new String[]{this.mBeanName}), (Service)mbeanRegistrationService).addDependency(this.mbeanServerServiceName, MBeanServer.class, mbeanRegistrationService.getMBeanServerInjector()).addDependency(this.startStopServiceName, Object.class, mbeanRegistrationService.getValueInjector()).install();
        this.installed = true;
    }

    private void assertState() {
        if (this.installed) {
            throw new IllegalStateException();
        }
    }
}

