/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.history;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.history.History;
import org.jboss.aesh.history.SearchDirection;

public class InMemoryHistory
extends History {
    private final List<String> historyList;
    private int lastFetchedId = -1;
    private int lastSearchedId = 0;
    private String current;
    private SearchDirection searchDirection = SearchDirection.REVERSE;
    private final int maxSize;
    private String lastSearchArgument;

    public InMemoryHistory() {
        this(500);
    }

    public InMemoryHistory(int maxSize) {
        this.maxSize = maxSize == -1 ? Integer.MAX_VALUE : maxSize;
        this.historyList = new ArrayList<String>();
        this.current = "";
    }

    @Override
    public void push(String entry) {
        if (entry != null && entry.trim().length() > 0) {
            if (this.historyList.size() > 0 && this.historyList.get(this.historyList.size() - 1).equals(entry.trim())) {
                this.lastFetchedId = this.size();
                return;
            }
            if (this.historyList.size() >= this.maxSize) {
                this.historyList.remove(0);
            }
            this.historyList.add(entry.trim());
            this.lastFetchedId = this.size();
            this.lastSearchedId = 0;
        }
    }

    @Override
    public String find(String search) {
        int index = this.historyList.indexOf(search);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    @Override
    public String get(int index) {
        return this.historyList.get(index);
    }

    @Override
    public int size() {
        return this.historyList.size();
    }

    @Override
    public void setSearchDirection(SearchDirection direction) {
        this.searchDirection = direction;
        this.lastSearchedId = -1;
    }

    @Override
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    @Override
    public String getPreviousFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastFetchedId > 0) {
            return this.get(--this.lastFetchedId);
        }
        return this.get(this.lastFetchedId);
    }

    @Override
    public String getNextFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastFetchedId < this.size() - 1) {
            return this.get(++this.lastFetchedId);
        }
        if (this.lastFetchedId == this.size() - 1) {
            ++this.lastFetchedId;
            return this.getCurrent();
        }
        return this.getCurrent();
    }

    @Override
    public String search(String search) {
        if (this.searchDirection == SearchDirection.REVERSE) {
            return this.searchReverse(search);
        }
        return this.searchForward(search);
    }

    private String searchReverse(String search) {
        if (this.lastSearchedId <= 0) {
            this.lastSearchedId = this.size() - 1;
        } else if (this.lastSearchArgument.equals(search)) {
            --this.lastSearchedId;
        }
        while (this.lastSearchedId >= 0) {
            if (this.historyList.get(this.lastSearchedId).contains(search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastSearchedId);
            }
            --this.lastSearchedId;
        }
        return null;
    }

    private String searchForward(String search) {
        if (this.lastSearchedId >= this.size()) {
            this.lastSearchedId = 0;
        } else if (this.lastSearchArgument.equals(search)) {
            ++this.lastSearchedId;
        }
        while (this.lastSearchedId < this.size()) {
            if (this.historyList.get(this.lastSearchedId).contains(search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastSearchedId);
            }
            ++this.lastSearchedId;
        }
        return null;
    }

    @Override
    public void setCurrent(String line) {
        this.current = line;
    }

    @Override
    public String getCurrent() {
        return this.current;
    }

    @Override
    public List<String> getAll() {
        return this.historyList;
    }

    @Override
    public void clear() {
        this.lastFetchedId = -1;
        this.lastSearchedId = 0;
        this.historyList.clear();
        this.current = "";
    }

    @Override
    public void stop() {
    }
}

