/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public class Reclaimer {
    private static boolean trace = ActiveMQJournalLogger.LOGGER.isTraceEnabled();

    private static void trace(String message) {
        ActiveMQJournalLogger.LOGGER.trace(message);
    }

    public void scan(JournalFile[] files) {
        block0: for (int i = 0; i < files.length; ++i) {
            int j;
            JournalFile currentFile = files[i];
            int posCount = currentFile.getPosCount();
            int totNeg = 0;
            if (trace) {
                Reclaimer.trace("posCount on " + currentFile + " = " + posCount);
            }
            for (j = i; j < files.length; ++j) {
                if (trace && files[j].getNegCount(currentFile) != 0) {
                    Reclaimer.trace("Negative from " + files[j] + " into " + currentFile + " = " + files[j].getNegCount(currentFile));
                }
                totNeg += files[j].getNegCount(currentFile);
            }
            currentFile.setCanReclaim(true);
            if (posCount <= totNeg) {
                for (j = 0; j <= i; ++j) {
                    JournalFile file = files[j];
                    int negCount = currentFile.getNegCount(file);
                    if (negCount == 0 || file.isCanReclaim()) continue;
                    if (trace) {
                        Reclaimer.trace(currentFile + " Can't be reclaimed because " + file + " has negative values");
                    }
                    currentFile.setCanReclaim(false);
                    continue block0;
                }
                continue;
            }
            currentFile.setCanReclaim(false);
        }
    }
}

