/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.SelectionKey;
import org.xnio.IoUtils;
import org.xnio.nio.ChannelClosed;
import org.xnio.nio.NioHandle;
import org.xnio.nio.QueuedNioTcpServer;
import org.xnio.nio.WorkerThread;

final class QueuedNioTcpServerHandle
extends NioHandle
implements ChannelClosed {
    private final QueuedNioTcpServer server;

    QueuedNioTcpServerHandle(QueuedNioTcpServer server, WorkerThread workerThread, SelectionKey key, int highWater, int lowWater) {
        super(workerThread, key);
        this.server = server;
    }

    @Override
    void handleReady(int ops) {
        this.server.handleReady();
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)this.server);
    }

    @Override
    void terminated() {
        this.server.invokeCloseHandler();
    }

    @Override
    public void channelClosed() {
        this.freeConnection();
    }

    void freeConnection() {
    }

    int getConnectionCount() {
        return -1;
    }
}

