/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

class ServerRemove
extends AbstractRemoveStepHandler {
    static final ServerRemove INSTANCE = new ServerRemove();

    ServerRemove() {
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        context.deregisterCapability(ServerDefinition.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(context.getCurrentAddressValue()));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                ServerRemove.removeActiveMQServer(serverName, context, resource);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static void removeActiveMQServer(String serverName, OperationContext context, Resource resource) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(serverName);
        for (Resource.ResourceEntry jmsQueue : resource.getChildren("jms-queue")) {
            context.removeService(JMSServices.getJmsQueueBaseServiceName(serviceName).append(new String[]{jmsQueue.getName()}));
        }
        for (Resource.ResourceEntry jmsTopic : resource.getChildren("jms-topic")) {
            context.removeService(JMSServices.getJmsTopicBaseServiceName(serviceName).append(new String[]{jmsTopic.getName()}));
        }
        for (Resource.ResourceEntry cf : resource.getChildren("connection-factory")) {
            context.removeService(JMSServices.getConnectionFactoryBaseServiceName(serviceName).append(new String[]{cf.getName()}));
        }
        for (Resource.ResourceEntry pcf : resource.getChildren("pooled-connection-factory")) {
            context.removeService(JMSServices.getPooledConnectionFactoryBaseServiceName(serviceName).append(new String[]{pcf.getName()}));
        }
        for (Resource.ResourceEntry queue : resource.getChildren("queue")) {
            context.removeService(MessagingServices.getQueueBaseServiceName(serviceName).append(new String[]{queue.getName()}));
        }
        context.removeService(JMSServices.getJmsManagerBaseServiceName(serviceName));
        context.removeService(MessagingServices.getActiveMQServiceName(serverName));
        for (Resource.ResourceEntry broadcastGroup : resource.getChildren("broadcast-group")) {
            context.removeService(GroupBindingService.getBroadcastBaseServiceName(serviceName).append(new String[]{broadcastGroup.getName()}));
        }
        for (Resource.ResourceEntry divertGroup : resource.getChildren("discovery-group")) {
            context.removeService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{divertGroup.getName()}));
        }
        for (Resource.ResourceEntry path : resource.getChildren("path")) {
            context.removeService(serviceName.append(new String[]{"paths"}).append(new String[]{path.getName()}));
        }
    }
}

