/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManager;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactory<A, D>
extends AbstractService<SSOManagerFactory<A, D, TransactionBatch>>
implements SSOManagerFactory<A, D, TransactionBatch> {
    private final InfinispanSSOManagerFactoryConfiguration configuration;

    public InfinispanSSOManagerFactory(InfinispanSSOManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <L> SSOManager<A, D, L, TransactionBatch> createSSOManager(IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this.configuration.getModuleLoader()), null);
        SimpleMarshalledValueFactory marshalledValueFactory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)marshalledValueFactory, (Object)marshallingContext);
        Cache cache = this.configuration.getCache();
        Configuration config = cache.getCacheConfiguration();
        boolean lockOnRead = config.transaction().transactionMode().isTransactional() && config.transaction().lockingMode() == LockingMode.PESSIMISTIC && config.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        CoarseSSOFactory factory = new CoarseSSOFactory((Cache<? extends Key<String>, ?>)((Cache<Key<String>, ?>)cache), marshaller, localContextFactory, lockOnRead);
        AffinityIdentifierFactory<String> idFactory = new AffinityIdentifierFactory<String>(identifierFactory, cache, this.configuration.getKeyAffinityServiceFactory());
        InfinispanBatcher batcher = new InfinispanBatcher(cache);
        return new InfinispanSSOManager(factory, idFactory, (Batcher<TransactionBatch>)batcher);
    }

    static enum MarshallingVersion implements Function<ModuleLoader, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(ModuleLoader loader) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
                config.setClassTable((ClassTable)new SimpleClassTable((Externalizer)IndexExternalizer.UNSIGNED_BYTE, new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

