/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;

public class LocalServiceProviderRegistry<T>
implements ServiceProviderRegistry<T> {
    final Set<T> services = Collections.synchronizedSet(new HashSet());
    private final Group group;

    public LocalServiceProviderRegistry(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(final T service) {
        this.services.add(service);
        return new AbstractServiceProviderRegistration<T>(service, this){

            public void close() {
                LocalServiceProviderRegistry.this.services.remove(service);
            }
        };
    }

    public ServiceProviderRegistration<T> register(T service, ServiceProviderRegistration.Listener listener) {
        return this.register(service);
    }

    public Set<Node> getProviders(T service) {
        return this.services.contains(service) ? Collections.singleton(this.getGroup().getLocalNode()) : Collections.emptySet();
    }

    public Set<T> getServices() {
        return this.services;
    }
}

