/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    protected final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentFullReplaceHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentFullReplaceHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentFullReplaceHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        byte[] newHash;
        ModelNode correctedOperation = operation.clone();
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateAndSet(operation, correctedOperation);
        }
        String name = DeploymentAttributes.NAME.resolveModelAttribute(context, correctedOperation).asString();
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        String runtimeName = correctedOperation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? correctedOperation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        ModelNode content = correctedOperation.require("content").clone();
        ModelNode deploymentModel = context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath})).getModel();
        String replacedRuntimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, deploymentModel).asString();
        final PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath});
        ModelNode replacedContent = deploymentModel.get("content").get(0);
        final byte[] replacedHash = replacedContent.hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, replacedContent).asBytes() : null;
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            newHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
            ContentReference reference = ModelContentReference.fromModelAddress(address, newHash);
            contentItem = this.addFromHash(reference);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, contentItemNode);
            newHash = contentItem.getHash();
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(newHash);
            content.clear();
            content.add(contentItemNode);
        } else {
            contentItem = this.addUnmanaged(context, contentItemNode);
            newHash = null;
        }
        deploymentModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        deploymentModel.get("content").set(content);
        if (!operation.hasDefined(DeploymentAttributes.PERSISTENT.getName())) {
            operation.get(DeploymentAttributes.PERSISTENT.getName()).set(true);
        }
        DeploymentAttributes.PERSISTENT.validateAndSet(operation, deploymentModel);
        DeploymentAttributes.OWNER.validateAndSet(operation, deploymentModel);
        boolean wasDeployed = true;
        if (operation.hasDefined(DeploymentAttributes.ENABLED.getName())) {
            wasDeployed = DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean();
            DeploymentAttributes.ENABLED.validateAndSet(operation, deploymentModel);
        }
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean()) {
            DeploymentUtils.enableAttribute(deploymentModel);
        } else if (wasDeployed) {
            DeploymentUtils.disableAttribute(deploymentModel);
        }
        boolean persistent = DeploymentAttributes.PERSISTENT.resolveModelAttribute(context, operation).asBoolean();
        Resource resource = Resource.Factory.create((!persistent ? 1 : 0) != 0);
        resource.writeModel(deploymentModel);
        context.addResource(PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath}), resource);
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean()) {
            DeploymentHandlerUtil.replace(context, deploymentModel, runtimeName, name, replacedRuntimeName, this.vaultReader, contentItem);
        } else if (wasDeployed) {
            DeploymentHandlerUtil.undeploy(context, operation, name, runtimeName, this.vaultReader);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(replacedHash == null || newHash != null && Arrays.equals(replacedHash, newHash))) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, replacedHash));
                    }
                    if (newHash != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, newHash));
                    }
                } else if (!(newHash == null || replacedHash != null && Arrays.equals(replacedHash, newHash))) {
                    DeploymentFullReplaceHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, newHash));
                }
            }
        });
    }

    DeploymentHandlerUtil.ContentItem addFromHash(ContentReference reference) throws OperationFailedException {
        if (!this.contentRepository.syncContent(reference)) {
            throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(reference.getHexHash());
        }
        return new DeploymentHandlerUtil.ContentItem(reference.getHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        contentItemNode.clear();
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(hash);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        String path = DeploymentAttributes.CONTENT_PATH.resolveModelAttribute(context, contentItemNode).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = DeploymentAttributes.CONTENT_ARCHIVE.resolveModelAttribute(context, contentItemNode).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

