/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;

public final class RelationAlreadyExistsException
extends InventoryException {
    private final String relationName;
    private final Filter[][] path;

    public RelationAlreadyExistsException(Throwable cause, String relationName, Filter[] path) {
        super(cause);
        this.relationName = relationName;
        this.path = new Filter[1][];
        this.path[0] = path;
    }

    public RelationAlreadyExistsException(Throwable cause, String relationName, Filter[][] path) {
        super(cause);
        this.relationName = relationName;
        this.path = path;
    }

    public RelationAlreadyExistsException(String relationName, Filter[] path) {
        this(null, relationName, path);
    }

    public RelationAlreadyExistsException(String relationName, Filter[][] path) {
        this(null, relationName, path);
    }

    public RelationAlreadyExistsException(Entity entity) {
        this(entity.getId(), Filter.pathTo(entity));
    }

    @Override
    public String getMessage() {
        return "Relation with id '" + this.relationName + "' already exists at some of the positions: " + Arrays.deepToString((Object[])this.path);
    }

    public String getRelationName() {
        return this.relationName;
    }

    public Filter[][] getPath() {
        return this.path;
    }
}

