/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.SegmentType;

public final class RelationNotFoundException
extends InventoryException {
    private final String sourceEntityType;
    private final Filter[][] filters;
    private final String nameOrId;

    public RelationNotFoundException(SegmentType sourceEntityType, String nameOrId, Filter[] filters, String message, Throwable cause) {
        this(sourceEntityType == null ? null : sourceEntityType.getSimpleName(), nameOrId, RelationNotFoundException.oneElem(filters), message, cause);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[] filters, String message, Throwable cause) {
        this(sourceEntityType, nameOrId, RelationNotFoundException.oneElem(filters), message, cause);
    }

    public RelationNotFoundException(SegmentType sourceEntityType, String nameOrId, Filter[][] filters, String message, Throwable cause) {
        this(sourceEntityType == null ? null : sourceEntityType.getSimpleName(), nameOrId, filters, message, cause);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[][] filters, String message, Throwable cause) {
        this(sourceEntityType == null ? null : sourceEntityType.getSimpleName(), nameOrId, filters, message, cause);
    }

    private RelationNotFoundException(String sourceEntityType, String nameOrId, Filter[][] filters, String message, Throwable cause) {
        super(message, cause);
        this.sourceEntityType = sourceEntityType;
        this.filters = filters;
        this.nameOrId = nameOrId;
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[] filters, Throwable cause) {
        this(sourceEntityType, nameOrId, filters, null, cause);
    }

    public RelationNotFoundException(String nameOrId, Filter[] filters, String message) {
        this((String)null, nameOrId, RelationNotFoundException.oneElem(filters), message, null);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, Filter[] filters) {
        this(sourceEntityType, null, filters, null, null);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, Filter[][] filters) {
        this(sourceEntityType, null, filters, null, null);
    }

    public RelationNotFoundException(String nameOrId, Filter[] filters) {
        this((String)null, nameOrId, RelationNotFoundException.oneElem(filters), null, null);
    }

    public RelationNotFoundException(String nameOrId, Filter[][] filters) {
        this((String)null, nameOrId, filters, null, null);
    }

    @Override
    public String getMessage() {
        return "Relation" + (this.sourceEntityType != null ? " with source in " + this.sourceEntityType : "") + (this.nameOrId != null ? " with name or id '" + this.nameOrId + "'" : "") + (this.filters != null ? " searched for using any of the filters: " + Arrays.deepToString((Object[])this.filters) : "") + (super.getMessage() == null ? ": Was not found." : ": " + super.getMessage());
    }

    private static Filter[][] oneElem(Filter[] elem) {
        Filter[][] ret = new Filter[][]{elem};
        return ret;
    }

    public String getNameOrId() {
        return this.nameOrId;
    }

    public String getSourceEntityType() {
        return this.sourceEntityType;
    }

    public Filter[][] getFilters() {
        return this.filters;
    }
}

