/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func0;
import rx.functions.Func1;

public final class OperatorMapNotification<T, R>
implements Observable.Operator<R, T> {
    private final Func1<? super T, ? extends R> onNext;
    private final Func1<? super Throwable, ? extends R> onError;
    private final Func0<? extends R> onCompleted;

    public OperatorMapNotification(Func1<? super T, ? extends R> onNext, Func1<? super Throwable, ? extends R> onError, Func0<? extends R> onCompleted) {
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> o) {
        return new Subscriber<T>(o){

            @Override
            public void onCompleted() {
                try {
                    o.onNext(OperatorMapNotification.this.onCompleted.call());
                    o.onCompleted();
                }
                catch (Throwable e) {
                    o.onError(e);
                }
            }

            @Override
            public void onError(Throwable e) {
                try {
                    o.onNext(OperatorMapNotification.this.onError.call(e));
                    o.onCompleted();
                }
                catch (Throwable e2) {
                    o.onError(e);
                }
            }

            @Override
            public void onNext(T t) {
                try {
                    o.onNext(OperatorMapNotification.this.onNext.call(t));
                }
                catch (Throwable e) {
                    o.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                }
            }
        };
    }
}

