/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deliveryactive.metadata.EJBBoundMdbDeliveryMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.DeliveryActive;
import org.jboss.ejb3.annotation.DeliveryGroup;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class MdbDeliveryMergingProcessor
extends AbstractMergingProcessor<MessageDrivenComponentDescription> {
    public MdbDeliveryMergingProcessor() {
        super(MessageDrivenComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        ClassAnnotationInformation deliveryGroup;
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation deliveryActive = clazz.getAnnotationInformation(DeliveryActive.class);
        if (deliveryActive != null && !deliveryActive.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setDeliveryActive((Boolean)deliveryActive.getClassLevelAnnotations().get(0));
        }
        if ((deliveryGroup = clazz.getAnnotationInformation(DeliveryGroup.class)) != null && !deliveryGroup.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setDeliveryGroup((String)deliveryGroup.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String ejbName = componentConfiguration.getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        Boolean deliveryActive = null;
        String deliveryGroup = null;
        List deliveryMetaDataList = assemblyDescriptor.getAny(EJBBoundMdbDeliveryMetaData.class);
        if (deliveryMetaDataList != null) {
            for (EJBBoundMdbDeliveryMetaData deliveryMetaData : deliveryMetaDataList) {
                if ("*".equals(deliveryMetaData.getEjbName()) && deliveryActive == null && deliveryGroup == null) {
                    deliveryActive = deliveryMetaData.isDeliveryActive();
                    deliveryGroup = deliveryMetaData.getDeliveryGroup();
                    continue;
                }
                if (!ejbName.equals(deliveryMetaData.getEjbName())) continue;
                deliveryActive = deliveryMetaData.isDeliveryActive();
                deliveryGroup = deliveryMetaData.getDeliveryGroup();
            }
        }
        if (deliveryGroup != null) {
            componentConfiguration.setDeliveryGroup(deliveryGroup);
        } else if (deliveryActive != null) {
            componentConfiguration.setDeliveryActive(deliveryActive);
        }
    }
}

