/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.lucene.works.AddWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.ByTermDeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.ByTermUpdateWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteByQueryWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteExtWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.FlushWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.OptimizeWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.PurgeAllWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateExtWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkExecutor;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexUpdateVisitor
implements IndexWorkVisitor<Void, LuceneWorkExecutor> {
    private static final Log log = LoggerFactory.make();
    private final AddWorkExecutor addExecutor;
    private final DeleteWorkExecutor deleteExecutor;
    private final UpdateWorkExecutor updateExecutor;
    private final OptimizeWorkExecutor optimizeExecutor;
    private final PurgeAllWorkExecutor purgeAllExecutor;
    private final FlushWorkExecutor flushExecutor;
    private final DeleteByQueryWorkExecutor deleteByQueryExecutor;

    public IndexUpdateVisitor(Workspace workspace) {
        this.addExecutor = new AddWorkExecutor(workspace);
        if (workspace.areSingleTermDeletesSafe()) {
            this.deleteExecutor = new DeleteExtWorkExecutor(workspace);
            this.updateExecutor = new UpdateExtWorkExecutor(workspace, this.addExecutor);
        } else if (workspace.isDeleteByTermEnforced()) {
            this.deleteExecutor = new ByTermDeleteWorkExecutor(workspace);
            this.updateExecutor = new ByTermUpdateWorkExecutor(workspace, this.addExecutor);
        } else {
            this.deleteExecutor = new DeleteWorkExecutor(workspace);
            this.updateExecutor = new UpdateWorkExecutor(this.deleteExecutor, this.addExecutor);
            log.singleTermDeleteDisabled(workspace.getIndexName());
        }
        this.purgeAllExecutor = new PurgeAllWorkExecutor(workspace);
        this.optimizeExecutor = new OptimizeWorkExecutor(workspace);
        this.flushExecutor = new FlushWorkExecutor(workspace);
        this.deleteByQueryExecutor = new DeleteByQueryWorkExecutor(workspace);
    }

    @Override
    public LuceneWorkExecutor visitAddWork(AddLuceneWork addLuceneWork, Void p) {
        return this.addExecutor;
    }

    @Override
    public LuceneWorkExecutor visitDeleteWork(DeleteLuceneWork deleteLuceneWork, Void p) {
        return this.deleteExecutor;
    }

    @Override
    public LuceneWorkExecutor visitOptimizeWork(OptimizeLuceneWork optimizeLuceneWork, Void p) {
        return this.optimizeExecutor;
    }

    @Override
    public LuceneWorkExecutor visitPurgeAllWork(PurgeAllLuceneWork purgeAllLuceneWork, Void p) {
        return this.purgeAllExecutor;
    }

    @Override
    public LuceneWorkExecutor visitUpdateWork(UpdateLuceneWork updateLuceneWork, Void p) {
        return this.updateExecutor;
    }

    @Override
    public LuceneWorkExecutor visitFlushWork(FlushLuceneWork flushLuceneWork, Void p) {
        return this.flushExecutor;
    }

    @Override
    public LuceneWorkExecutor visitDeleteByQueryWork(DeleteByQueryLuceneWork deleteByQueryLuceneWork, Void p) {
        return this.deleteByQueryExecutor;
    }
}

