/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new FunctionWeight(searcher);
    }

    public String toString(String field) {
        float boost = this.getBoost();
        return ((double)boost != 1.0 ? "(" : "") + this.func.toString() + ((double)boost == 1.0 ? "" : ")^" + boost);
    }

    public boolean equals(Object o) {
        if (!FunctionQuery.class.isInstance(o)) {
            return false;
        }
        FunctionQuery other = (FunctionQuery)((Object)o);
        return super.equals(o) && this.func.equals(other.func);
    }

    public int hashCode() {
        return super.hashCode() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float qWeight;
        int doc;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float qWeight) throws IOException {
            super((Weight)w);
            this.doc = -1;
            this.weight = w;
            this.qWeight = qWeight;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            ++this.doc;
            if (this.doc >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            return this.doc;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public float score() throws IOException {
            float score = this.qWeight * this.vals.floatVal(this.doc);
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        public long cost() {
            return this.maxDoc;
        }

        public int freq() throws IOException {
            return 1;
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            return Explanation.match((float)sc, (String)("FunctionQuery(" + FunctionQuery.this.func + "), product of:"), (Explanation[])new Explanation[]{this.vals.explain(doc), Explanation.match((float)FunctionQuery.this.getBoost(), (String)"boost", (Explanation[])new Explanation[0]), Explanation.match((float)this.weight.queryNorm, (String)"queryNorm", (Explanation[])new Explanation[0])});
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected float queryNorm;
        protected float queryWeight;
        protected final Map context;

        public FunctionWeight(IndexSearcher searcher) throws IOException {
            super((Query)FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
        }

        public void extractTerms(Set<Term> terms) {
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = FunctionQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new AllScorer(context, this, this.queryWeight);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc);
        }
    }
}

