/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.dmr.Base64;
import org.jboss.dmr.BigDecimalModelValue;
import org.jboss.dmr.BigIntegerModelValue;
import org.jboss.dmr.BooleanModelValue;
import org.jboss.dmr.BytesModelValue;
import org.jboss.dmr.DoubleModelValue;
import org.jboss.dmr.ExpressionValue;
import org.jboss.dmr.IntModelValue;
import org.jboss.dmr.JSONParserImpl;
import org.jboss.dmr.ListModelValue;
import org.jboss.dmr.LongModelValue;
import org.jboss.dmr.ModelNodeParser;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.ObjectModelValue;
import org.jboss.dmr.Property;
import org.jboss.dmr.PropertyModelValue;
import org.jboss.dmr.StringModelValue;
import org.jboss.dmr.TypeModelValue;
import org.jboss.dmr.ValueExpression;

public class ModelNode
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 2030456323088551487L;
    private boolean protect = false;
    private ModelValue value = ModelValue.UNDEFINED;

    public ModelNode() {
    }

    public ModelNode(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = new BigDecimalModelValue(value);
    }

    public ModelNode(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = new BigIntegerModelValue(value);
    }

    public ModelNode(boolean value) {
        this(value ? BooleanModelValue.TRUE : BooleanModelValue.FALSE);
    }

    public ModelNode(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = new BytesModelValue(value);
    }

    public ModelNode(double value) {
        this.value = new DoubleModelValue(value);
    }

    public ModelNode(int value) {
        this.value = new IntModelValue(value);
    }

    public ModelNode(long value) {
        this.value = new LongModelValue(value);
    }

    public ModelNode(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = new StringModelValue(value);
    }

    public ModelNode(ValueExpression value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = new ExpressionValue(value);
    }

    public ModelNode(ModelType value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = TypeModelValue.of(value);
    }

    ModelNode(ModelValue value) {
        this.value = value;
    }

    public void protect() {
        if (!this.protect) {
            this.protect = true;
            this.value = this.value.protect();
        }
    }

    public long asLong() throws IllegalArgumentException {
        return this.value.asLong();
    }

    public long asLong(long defVal) {
        return this.value.asLong(defVal);
    }

    public int asInt() throws IllegalArgumentException {
        return this.value.asInt();
    }

    public int asInt(int defVal) {
        return this.value.asInt(defVal);
    }

    public boolean asBoolean() throws IllegalArgumentException {
        return this.value.asBoolean();
    }

    public boolean asBoolean(boolean defVal) {
        return this.value.asBoolean(defVal);
    }

    public String asString() {
        return this.value.asString();
    }

    public double asDouble() throws IllegalArgumentException {
        return this.value.asDouble();
    }

    public double asDouble(double defVal) {
        return this.value.asDouble(defVal);
    }

    public ModelType asType() throws IllegalArgumentException {
        return this.value.asType();
    }

    public BigDecimal asBigDecimal() throws IllegalArgumentException {
        return this.value.asBigDecimal();
    }

    public BigInteger asBigInteger() throws IllegalArgumentException {
        return this.value.asBigInteger();
    }

    public byte[] asBytes() throws IllegalArgumentException {
        return this.value.asBytes();
    }

    public ValueExpression asExpression() throws IllegalArgumentException {
        return this.value.asExpression();
    }

    public Property asProperty() throws IllegalArgumentException {
        return this.value.asProperty();
    }

    public List<Property> asPropertyList() throws IllegalArgumentException {
        return this.value.asPropertyList();
    }

    public ModelNode asObject() throws IllegalArgumentException {
        return this.value.asObject();
    }

    public boolean isDefined() {
        return this.getType() != ModelType.UNDEFINED;
    }

    public ModelNode set(int newValue) {
        this.checkProtect();
        this.value = new IntModelValue(newValue);
        return this;
    }

    public ModelNode set(long newValue) {
        this.checkProtect();
        this.value = new LongModelValue(newValue);
        return this;
    }

    public ModelNode set(double newValue) {
        this.checkProtect();
        this.value = new DoubleModelValue(newValue);
        return this;
    }

    public ModelNode set(boolean newValue) {
        this.checkProtect();
        this.value = BooleanModelValue.valueOf(newValue);
        return this;
    }

    @Deprecated
    public ModelNode setExpression(String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new ExpressionValue(newValue);
        return this;
    }

    public ModelNode set(ValueExpression newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new ExpressionValue(newValue);
        return this;
    }

    public ModelNode set(String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new StringModelValue(newValue);
        return this;
    }

    public ModelNode set(BigDecimal newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new BigDecimalModelValue(newValue);
        return this;
    }

    public ModelNode set(BigInteger newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new BigIntegerModelValue(newValue);
        return this;
    }

    public ModelNode set(ModelNode newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = newValue.value.copy();
        return this;
    }

    void setNoCopy(ModelNode child) {
        this.value = child.value;
    }

    public ModelNode set(byte[] newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = new BytesModelValue(newValue.length == 0 ? newValue : (byte[])newValue.clone());
        return this;
    }

    public ModelNode set(ModelType newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        this.value = TypeModelValue.of(newValue);
        return this;
    }

    public ModelNode set(Property newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.set(newValue.getName(), newValue.getValue());
        return this;
    }

    public ModelNode set(String propertyName, ModelNode propertyValue) {
        this.checkProtect();
        this.value = new PropertyModelValue(propertyName, propertyValue, true);
        return this;
    }

    ModelNode setNoCopy(String propertyName, ModelNode propertyValue) {
        this.value = new PropertyModelValue(propertyName, propertyValue, false);
        return this;
    }

    public ModelNode set(String propertyName, int propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, long propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, double propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, boolean propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, String propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    @Deprecated
    public ModelNode setExpression(String propertyName, String propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.setExpression(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, ValueExpression propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, BigDecimal propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, BigInteger propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, byte[] propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(String propertyName, ModelType propertyValue) {
        this.checkProtect();
        ModelNode node = new ModelNode();
        node.set(propertyValue);
        this.value = new PropertyModelValue(propertyName, node);
        return this;
    }

    public ModelNode set(Collection<ModelNode> newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        this.checkProtect();
        ArrayList<ModelNode> list = new ArrayList<ModelNode>(newValue.size());
        for (ModelNode node : newValue) {
            if (node == null) {
                list.add(new ModelNode());
                continue;
            }
            list.add(node.clone());
        }
        this.value = new ListModelValue(list);
        return this;
    }

    public ModelNode setEmptyList() {
        this.checkProtect();
        this.value = new ListModelValue();
        return this;
    }

    public ModelNode setEmptyObject() {
        this.checkProtect();
        this.value = new ObjectModelValue();
        return this;
    }

    public ModelNode clear() {
        this.checkProtect();
        this.value = ModelValue.UNDEFINED;
        return this;
    }

    public ModelNode get(String name) {
        ModelValue value = this.value;
        if (value == ModelValue.UNDEFINED) {
            this.checkProtect();
            this.value = new ObjectModelValue();
            return this.value.getChild(name);
        }
        return value.getChild(name);
    }

    public ModelNode require(String name) throws NoSuchElementException {
        return this.value.requireChild(name);
    }

    public ModelNode remove(String name) throws NoSuchElementException {
        return this.value.removeChild(name);
    }

    public ModelNode remove(int index) throws NoSuchElementException {
        return this.value.removeChild(index);
    }

    public ModelNode get(int index) {
        ModelValue value = this.value;
        if (value == ModelValue.UNDEFINED) {
            this.checkProtect();
            this.value = new ListModelValue();
            return this.value.getChild(index);
        }
        return value.getChild(index);
    }

    public ModelNode require(int index) {
        return this.value.requireChild(index);
    }

    public ModelNode add(int newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(long newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(double newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(boolean newValue) {
        this.add().set(newValue);
        return this;
    }

    @Deprecated
    public ModelNode addExpression(String newValue) {
        this.add().setExpression(newValue);
        return this;
    }

    public ModelNode add(ValueExpression newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(String newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(BigDecimal newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(BigInteger newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(ModelNode newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode insert(ModelNode newValue, int index) {
        this.insert(index).set(newValue);
        return this;
    }

    ModelNode addNoCopy(ModelNode child) {
        this.add().value = child.value;
        return this;
    }

    public ModelNode add(byte[] newValue) {
        this.add().set(newValue);
        return this;
    }

    public ModelNode add(Property property) {
        this.add().set(property);
        return this;
    }

    public ModelNode add(String propertyName, int propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, long propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, double propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, boolean propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, ValueExpression propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, String propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, BigDecimal propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, BigInteger propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, ModelNode propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add(String propertyName, byte[] propertyValue) {
        this.add().set(propertyName, propertyValue);
        return this;
    }

    public ModelNode add() {
        this.checkProtect();
        ModelValue value = this.value;
        if (value == ModelValue.UNDEFINED) {
            this.value = new ListModelValue();
            return this.value.addChild();
        }
        return value.addChild();
    }

    public ModelNode insert(int index) {
        this.checkProtect();
        ModelValue value = this.value;
        if (value == ModelValue.UNDEFINED) {
            this.value = new ListModelValue();
            return this.value.insertChild(index);
        }
        return value.insertChild(index);
    }

    public ModelNode addEmptyList() {
        ModelNode node = this.add();
        node.setEmptyList();
        return node;
    }

    public ModelNode addEmptyObject() {
        ModelNode node = this.add();
        node.setEmptyObject();
        return node;
    }

    public boolean has(int index) {
        return this.value.has(index);
    }

    public boolean has(String key) {
        return this.value.has(key);
    }

    public boolean has(String ... names) {
        ModelNode current = this;
        for (String part : names) {
            if (!current.has(part)) {
                return false;
            }
            current = current.get(part);
        }
        return true;
    }

    public boolean hasDefined(int index) {
        return this.value.has(index) && this.get(index).isDefined();
    }

    public boolean hasDefined(String key) {
        return this.value.has(key) && this.get(key).isDefined();
    }

    public boolean hasDefined(String ... names) {
        ModelNode current = this;
        for (String part : names) {
            if (!current.hasDefined(part)) {
                return false;
            }
            current = current.get(part);
        }
        return true;
    }

    public Set<String> keys() {
        return this.value.getKeys();
    }

    public List<ModelNode> asList() {
        return this.value.asList();
    }

    public ModelNode get(String ... names) {
        ModelNode current = this;
        for (String part : names) {
            current = current.get(part);
        }
        return current;
    }

    public String toString() {
        return this.value.toString();
    }

    public void writeString(PrintWriter writer, boolean compact) {
        this.value.writeString(writer, compact);
    }

    public String toJSONString(boolean compact) {
        return this.value.toJSONString(compact);
    }

    public void writeJSONString(PrintWriter writer, boolean compact) {
        this.value.writeJSONString(writer, compact);
    }

    public static ModelNode fromString(String input) {
        ModelNodeParser parser = new ModelNodeParser();
        try {
            parser.setInput(new ByteArrayInputStream(input.getBytes("US-ASCII")));
            if (parser.yyParse() > 0) {
                throw new IllegalArgumentException("DMR parser error");
            }
            return parser.getResult();
        }
        catch (IOException e) {
            IllegalArgumentException n = new IllegalArgumentException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public static ModelNode fromJSONString(String input) {
        JSONParserImpl parser = new JSONParserImpl();
        try {
            parser.setInput(new ByteArrayInputStream(input.getBytes("UTF-8")));
            if (parser.yyParse() > 0) {
                throw new IllegalArgumentException("JSON parser error");
            }
            return parser.getResult();
        }
        catch (IOException e) {
            IllegalArgumentException n = new IllegalArgumentException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public static ModelNode fromStream(InputStream stream) throws IOException {
        ModelNodeParser parser = new ModelNodeParser();
        parser.setInput(stream);
        if (parser.yyParse() > 0) {
            throw new IOException("Parser error");
        }
        return parser.getResult();
    }

    public static ModelNode fromJSONStream(InputStream stream) throws IOException {
        JSONParserImpl parser = new JSONParserImpl();
        parser.setInput(stream);
        if (parser.yyParse() > 0) {
            throw new IOException("Parser error");
        }
        return parser.getResult();
    }

    public static ModelNode fromBase64(InputStream stream) throws IOException {
        Base64.InputStream bstream = new Base64.InputStream(stream);
        ModelNode node = new ModelNode();
        node.readExternal(bstream);
        bstream.close();
        return node;
    }

    public ModelNode resolve() {
        ModelNode newNode = new ModelNode();
        newNode.value = this.value.resolve();
        return newNode;
    }

    public boolean equals(Object other) {
        return other instanceof ModelNode && this.equals((ModelNode)other);
    }

    public boolean equals(ModelNode other) {
        return this == other || other != null && other.value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public ModelNode clone() {
        ModelNode clone = new ModelNode();
        clone.value = this.value.copy();
        return clone;
    }

    void format(PrintWriter writer, int indent, boolean multiLine) {
        this.value.format(writer, indent, multiLine);
    }

    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        this.value.formatAsJSON(writer, indent, multiLine);
    }

    public ModelType getType() {
        return this.value.getType();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void writeExternal(OutputStream out) throws IOException {
        this.writeExternal((DataOutput)new DataOutputStream(out));
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void writeExternal(DataOutput out) throws IOException {
        this.value.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    public void readExternal(DataInputStream in) throws IOException {
        this.readExternal((DataInput)in);
    }

    public void readExternal(InputStream in) throws IOException {
        this.readExternal((DataInput)new DataInputStream(in));
    }

    public void readExternal(DataInput in) throws IOException {
        this.checkProtect();
        try {
            char c = (char)(in.readByte() & 0xFF);
            ModelType type = ModelType.forChar(c);
            switch (type) {
                case UNDEFINED: {
                    this.value = ModelValue.UNDEFINED;
                    return;
                }
                case BIG_DECIMAL: {
                    this.value = new BigDecimalModelValue(in);
                    return;
                }
                case BIG_INTEGER: {
                    this.value = new BigIntegerModelValue(in);
                    return;
                }
                case BOOLEAN: {
                    this.value = BooleanModelValue.valueOf(in.readBoolean());
                    return;
                }
                case BYTES: {
                    this.value = new BytesModelValue(in);
                    return;
                }
                case DOUBLE: {
                    this.value = new DoubleModelValue(in.readDouble());
                    return;
                }
                case EXPRESSION: {
                    this.value = new ExpressionValue(in.readUTF());
                    return;
                }
                case INT: {
                    this.value = new IntModelValue(in.readInt());
                    return;
                }
                case LIST: {
                    this.value = new ListModelValue(in);
                    return;
                }
                case LONG: {
                    this.value = new LongModelValue(in.readLong());
                    return;
                }
                case OBJECT: {
                    this.value = new ObjectModelValue(in);
                    return;
                }
                case PROPERTY: {
                    this.value = new PropertyModelValue(in);
                    return;
                }
                case STRING: {
                    this.value = new StringModelValue(c, in);
                    return;
                }
                case TYPE: {
                    this.value = TypeModelValue.of(ModelType.forChar((char)(in.readByte() & 0xFF)));
                    return;
                }
            }
            throw new InvalidObjectException("Invalid type read: " + (Object)((Object)type));
        }
        catch (IllegalArgumentException e) {
            InvalidObjectException ne = new InvalidObjectException(e.getMessage());
            ne.initCause(e.getCause());
            throw ne;
        }
    }

    public void writeBase64(OutputStream stream) throws IOException {
        Base64.OutputStream bstream = new Base64.OutputStream(stream);
        this.writeExternal(bstream);
        bstream.flushBase64();
    }

    private void checkProtect() {
        if (this.protect) {
            throw new UnsupportedOperationException();
        }
    }
}

