/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.json;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.MapProvider;
import org.jboss.resteasy.plugins.providers.jaxb.json.JsonParsing;
import org.jboss.resteasy.plugins.providers.jaxb.json.i18n.Messages;
import org.jboss.resteasy.util.Types;

@Provider
@Produces(value={"application/*+json"})
@Consumes(value={"application/*+json"})
public class JsonMapProvider
extends MapProvider {
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Class baseType = Types.getMapValueType((Type)genericType);
        BufferedReader reader = null;
        String charset = (String)mediaType.getParameters().get("charset");
        reader = charset != null ? new BufferedReader(new InputStreamReader(entityStream, charset)) : new BufferedReader(new InputStreamReader(entityStream));
        char c = JsonParsing.eatWhitspace(reader, false);
        if (c != '{') {
            throw new JAXBUnmarshalException(Messages.MESSAGES.expectingJsonArray());
        }
        c = JsonParsing.eatWhitspace(reader, true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (c != '}') {
            MessageBodyReader messageReader = this.providers.getMessageBodyReader(baseType, null, annotations, mediaType);
            do {
                String key = JsonParsing.getJsonString(reader);
                c = JsonParsing.eatWhitspace(reader, false);
                if (c != ':') {
                    throw new JAXBUnmarshalException(Messages.MESSAGES.expectingColonMap());
                }
                c = JsonParsing.eatWhitspace(reader, true);
                String str = JsonParsing.extractJsonMapString(reader);
                ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
                Object obj = messageReader.readFrom(baseType, null, annotations, mediaType, httpHeaders, (InputStream)stream);
                map.put(key, obj);
                c = JsonParsing.eatWhitspace(reader, false);
                if (c == '}') break;
                if (c == ',') continue;
                throw new JAXBUnmarshalException(Messages.MESSAGES.expectingCommaJsonArray());
            } while ((c = JsonParsing.eatWhitspace(reader, true)) != '\uffffffff');
        }
        return map;
    }

    public static String getCharset(MediaType mediaType) {
        String charset;
        if (mediaType != null && (charset = (String)mediaType.getParameters().get("charset")) != null) {
            return charset;
        }
        return "UTF-8";
    }

    public void writeTo(Object target, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JAXBContextFinder finder = this.getFinder(mediaType);
        if (finder == null) {
            throw new JAXBMarshalException(Messages.MESSAGES.unableToFindJAXBContext(mediaType));
        }
        Class valueType = Types.getMapValueType((Type)genericType);
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, JsonMapProvider.getCharset(mediaType));
        MessageBodyWriter messageWriter = this.providers.getMessageBodyWriter(valueType, null, annotations, mediaType);
        writer.write(123);
        Map targetMap = (Map)target;
        Iterator it = targetMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry mapEntry = it.next();
            writer.write(34);
            writer.write(mapEntry.getKey().toString());
            writer.write(34);
            writer.write(58);
            writer.flush();
            messageWriter.writeTo(mapEntry.getValue(), valueType, null, annotations, mediaType, httpHeaders, entityStream);
            if (!it.hasNext()) continue;
            writer.write(44);
            writer.flush();
        }
        writer.write(125);
        writer.flush();
    }
}

