/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Hashtable;

public class ConstGen
implements com.sun.tools.corba.se.idl.ConstGen {
    protected Hashtable symbolTable = null;
    protected ConstEntry c = null;
    protected PrintWriter stream = null;

    @Override
    public void generate(Hashtable symbolTable, ConstEntry c, PrintWriter s) {
        this.symbolTable = symbolTable;
        this.c = c;
        this.stream = s;
        this.init();
        if (c.container() instanceof ModuleEntry) {
            this.generateConst();
        } else if (this.stream != null) {
            this.writeConstExpr();
        }
    }

    protected void init() {
    }

    protected void generateConst() {
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void openStream() {
        this.stream = Util.stream(this.c, ".java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.c);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        this.stream.println("public interface " + this.c.name());
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeConstExpr();
    }

    protected void writeConstExpr() {
        if (this.c.comment() != null) {
            this.c.comment().generate("  ", this.stream);
        }
        if (this.c.container() instanceof ModuleEntry) {
            this.stream.print("  public static final " + Util.javaName(this.c.type()) + " value = ");
        } else {
            this.stream.print("  public static final " + Util.javaName(this.c.type()) + ' ' + this.c.name() + " = ");
        }
        this.writeConstValue(this.c.type());
    }

    private void writeConstValue(SymtabEntry type) {
        if (type instanceof PrimitiveEntry) {
            this.stream.println('(' + Util.javaName(type) + ")(" + Util.parseExpression(this.c.value()) + ");");
        } else if (type instanceof StringEntry) {
            this.stream.println(Util.parseExpression(this.c.value()) + ';');
        } else if (type instanceof TypedefEntry) {
            while (type instanceof TypedefEntry) {
                type = type.type();
            }
            this.writeConstValue(type);
        } else {
            this.stream.println(Util.parseExpression(this.c.value()) + ';');
        }
    }

    protected void writeClosing() {
        this.stream.println("}");
    }

    protected void closeStream() {
        this.stream.close();
    }
}

