/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonLocationImpl;
import org.glassfish.json.api.BufferPool;

final class JsonTokenizer
implements Closeable {
    private final BufferPool bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private String value;
    private BigDecimal bd;

    JsonTokenizer(Reader reader, BufferPool bufferPool) {
        this.reader = reader;
        this.bufferPool = bufferPool;
        this.buf = bufferPool.take();
    }

    private void readString() {
        int ch;
        boolean inPlace = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block5: while (true) {
            if (inPlace && this.readBegin < this.readEnd) {
                do {
                    if ((ch = this.buf[this.readBegin]) >= 32 && ch <= 0x10FFFF && ch != 34 && ch != 92) {
                        ++this.readBegin;
                        continue;
                    }
                    if (ch != 34) break;
                    this.storeEnd = this.readBegin++;
                    return;
                } while (this.readBegin < this.readEnd);
                this.storeEnd = this.readBegin;
            }
            if ((ch = this.read()) >= 32 && ch <= 0x10FFFF && ch != 34 && ch != 92) {
                if (!inPlace) {
                    this.buf[this.storeEnd] = (char)ch;
                }
                ++this.storeEnd;
                continue;
            }
            switch (ch) {
                case 92: {
                    inPlace = false;
                    this.unescape();
                    continue block5;
                }
                case 34: {
                    return;
                }
                case -1: {
                    throw new JsonException("Unexpected EOF");
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
    }

    private void unescape() {
        int ch = this.read();
        switch (ch) {
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)ch;
                break;
            }
            case 117: {
                int unicode = 0;
                for (int i = 0; i < 4; ++i) {
                    int ch3 = this.read();
                    unicode = (char)(unicode << 4);
                    if (ch3 >= 48 && ch3 <= 57) {
                        unicode = (char)(unicode | (char)ch3 - 48);
                        continue;
                    }
                    if (ch3 >= 97 && ch3 <= 102) {
                        unicode = (char)(unicode | (char)ch3 - 97 + 10);
                        continue;
                    }
                    if (ch3 >= 65 && ch3 <= 70) {
                        unicode = (char)(unicode | (char)ch3 - 65 + 10);
                        continue;
                    }
                    throw new JsonParsingException("Unexpected Char=" + ch3, this.getLastCharLocation());
                }
                this.buf[this.storeEnd++] = (char)(unicode & 0xFFFF);
                break;
            }
            default: {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
    }

    private int readNumberChar() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.read();
    }

    private void readNumber(int ch) {
        int count;
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if (ch == 45) {
            this.minus = true;
            ch = this.readNumberChar();
            if (ch < 48 || ch > 57) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 48) {
            ch = this.readNumberChar();
        } else {
            while ((ch = this.readNumberChar()) >= 48 && ch <= 57) {
            }
        }
        if (ch == 46) {
            this.fracOrExp = true;
            count = 0;
            do {
                ch = this.readNumberChar();
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 101 || ch == 69) {
            this.fracOrExp = true;
            ch = this.readNumberChar();
            if (ch == 43 || ch == 45) {
                ch = this.readNumberChar();
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                ch = this.readNumberChar();
                ++count;
            }
            if (count == 0) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        --this.readBegin;
        this.storeEnd = this.readBegin;
    }

    private void readTrue() {
        char ch1 = (char)this.read();
        if (ch1 != 'r') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'r'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readFalse() {
        char ch1 = (char)this.read();
        if (ch1 != 'a') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'a'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 's') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 's'", this.getLastCharLocation());
        }
        char ch4 = (char)this.read();
        if (ch4 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch4 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readNull() {
        char ch1 = (char)this.read();
        if (ch1 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'l'", this.getLastCharLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    JsonToken nextToken() throws IOException {
        this.reset();
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            block19: {
                if (ch == 13) {
                    ++this.lineNo;
                    ch = this.read();
                    if (ch == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        break block19;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                        continue;
                    }
                }
                if (ch == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                }
            }
            ch = this.read();
        }
        switch (ch) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(ch);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw new JsonParsingException("Unexpected char=" + (char)ch, this.getLastCharLocation());
    }

    JsonLocation getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocation getLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int read() {
        try {
            if (this.readBegin == this.readEnd) {
                int len = this.fillBuf();
                if (len == -1) {
                    return -1;
                }
                assert (len != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + len;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while tokenizing JSON", ioe);
        }
    }

    private int fillBuf() throws IOException {
        if (this.storeEnd != 0) {
            int storeLen = this.storeEnd - this.storeBegin;
            if (storeLen > 0) {
                if (storeLen == this.buf.length) {
                    char[] doubleBuf = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = doubleBuf;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, storeLen);
                    this.storeEnd = storeLen;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void reset() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.value = null;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String getValue() {
        if (this.value == null) {
            this.value = new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.value;
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int storeLen = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (storeLen <= 9 || this.minus && storeLen == 10)) {
            int i;
            int num = 0;
            int n = i = this.minus ? 1 : 0;
            while (i < storeLen) {
                num = num * 10 + (this.buf[this.storeBegin + i] - 48);
                ++i;
            }
            return this.minus ? -num : num;
        }
        return this.getBigDecimal().intValue();
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    static enum JsonToken {
        CURLYOPEN(JsonParser.Event.START_OBJECT, false),
        SQUAREOPEN(JsonParser.Event.START_ARRAY, false),
        COLON(null, false),
        COMMA(null, false),
        STRING(JsonParser.Event.VALUE_STRING, true),
        NUMBER(JsonParser.Event.VALUE_NUMBER, true),
        TRUE(JsonParser.Event.VALUE_TRUE, true),
        FALSE(JsonParser.Event.VALUE_FALSE, true),
        NULL(JsonParser.Event.VALUE_NULL, true),
        CURLYCLOSE(JsonParser.Event.END_OBJECT, false),
        SQUARECLOSE(JsonParser.Event.END_ARRAY, false),
        EOF(null, false);

        private final JsonParser.Event event;
        private final boolean value;

        private JsonToken(JsonParser.Event event, boolean value) {
            this.event = event;
            this.value = value;
        }

        JsonParser.Event getEvent() {
            return this.event;
        }

        boolean isValue() {
            return this.value;
        }
    }
}

