/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.datasource;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class DefaultDataSourceBindingProcessor
implements DeploymentUnitProcessor {
    public static final String COMP_DEFAULT_DATASOURCE_JNDI_NAME = "java:comp/DefaultDataSource";
    public static final String MODULE_DEFAULT_DATASOURCE_JNDI_NAME = "java:module/DefaultDataSource";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        String defaultDataSource = moduleDescription.getDefaultResourceJndiNames().getDataSource();
        if (defaultDataSource == null) {
            return;
        }
        LookupInjectionSource injectionSource = new LookupInjectionSource(defaultDataSource);
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            moduleDescription.getBindingConfigurations().add(new BindingConfiguration(MODULE_DEFAULT_DATASOURCE_JNDI_NAME, (InjectionSource)injectionSource));
        } else {
            if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_DATASOURCE_JNDI_NAME, (InjectionSource)injectionSource));
            }
            for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                if (componentDescription.getNamingMode() != ComponentNamingMode.CREATE) continue;
                componentDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_DATASOURCE_JNDI_NAME, (InjectionSource)injectionSource));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

