/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.transaction.Transaction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.component.stateful.SerializedStatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class StatefulSessionComponentInstance
extends SessionBeanComponentInstance
implements Identifiable<SessionID>,
Contextual<Object> {
    private static final long serialVersionUID = 3803978357389448971L;
    private final SessionID id;
    private final Interceptor afterBegin;
    private final Interceptor afterCompletion;
    private final Interceptor beforeCompletion;
    private final Interceptor prePassivate;
    private final Interceptor postActivate;
    private final Interceptor ejb2XRemoveInterceptor;
    private volatile Transaction transaction;
    private final OwnableReentrantLock lock = new OwnableReentrantLock();
    private boolean synchronizationRegistered = false;
    private final Object threadLock = new Object();
    private boolean removed = false;

    boolean isSynchronizationRegistered() {
        return this.synchronizationRegistered;
    }

    void setSynchronizationRegistered(boolean synchronizationRegistered) {
        this.synchronizationRegistered = synchronizationRegistered;
    }

    Object getThreadLock() {
        return this.threadLock;
    }

    OwnableReentrantLock getLock() {
        return this.lock;
    }

    protected StatefulSessionComponentInstance(StatefulSessionComponent component, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        super(component, preDestroyInterceptor, methodInterceptors);
        SessionID existingSession = (SessionID)context.get(SessionID.class);
        this.id = existingSession != null ? existingSession : (SessionID)component.getCache().createIdentifier();
        this.afterBegin = component.getAfterBegin();
        this.afterCompletion = component.getAfterCompletion();
        this.beforeCompletion = component.getBeforeCompletion();
        this.prePassivate = component.getPrePassivate();
        this.postActivate = component.getPostActivate();
        this.ejb2XRemoveInterceptor = component.getEjb2XRemoveMethod();
    }

    protected void afterBegin() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_BEGIN);
        try {
            this.execute(this.afterBegin, this.getComponent().getAfterBeginMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void afterCompletion(boolean committed) {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION);
        try {
            this.execute(this.afterCompletion, this.getComponent().getAfterCompletionMethod(), committed);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void beforeCompletion() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
        try {
            this.execute(this.beforeCompletion, this.getComponent().getBeforeCompletionMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void prePassivate() {
        this.execute(this.prePassivate, null, new Object[0]);
    }

    protected void postActivate() {
        this.execute(this.postActivate, null, new Object[0]);
    }

    @Override
    public void discard() {
        if (!this.isDiscarded()) {
            super.discard();
            this.getComponent().getCache().discard(this);
        }
    }

    private Object execute(Interceptor interceptor, Method method, Object ... parameters) {
        if (interceptor == null) {
            return null;
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(InvokeMethodOnTargetInterceptor.PARAMETERS_KEY, (Object)parameters);
        interceptorContext.setContextData(new HashMap());
        interceptorContext.setTarget(this.getInstance());
        try {
            return interceptor.processInvocation(interceptorContext);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public StatefulSessionComponent getComponent() {
        return (StatefulSessionComponent)super.getComponent();
    }

    @Override
    public SessionID getId() {
        return this.id;
    }

    public Interceptor getEjb2XRemoveInterceptor() {
        return this.ejb2XRemoveInterceptor;
    }

    public String toString() {
        return " Instance of " + this.getComponent().getComponentName() + " {" + this.id + "}";
    }

    public Object writeReplace() throws ObjectStreamException {
        Set<Object> keys = this.getComponent().getSerialiableInterceptorContextKeys();
        HashMap<Object, Object> serializableInterceptors = new HashMap<Object, Object>();
        for (Object key : keys) {
            serializableInterceptors.put(key, this.getInstanceData(key));
        }
        return new SerializedStatefulSessionComponent((ManagedReference)this.getInstanceData(INSTANCE_KEY), this.id, this.getComponent().getCreateServiceName().getCanonicalName(), serializableInterceptors);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    boolean isRemoved() {
        return this.removed;
    }

    @Override
    public Object getCacheContext() {
        return this.getInstanceData(Contextual.class);
    }

    @Override
    public void setCacheContext(Object context) {
        this.setInstanceData(Contextual.class, context);
    }
}

