/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractHashTree;
import org.hawkular.inventory.api.model.ComputeHash;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

public final class IdentityHash {
    private IdentityHash() {
    }

    public static String of(MetadataPack.Members metadata) {
        ComputeHash.HashConstructor ctor = new ComputeHash.HashConstructor(new ComputeHash.DigestComputingWriter(ComputeHash.newDigest()));
        ComputeHash.HashableView metadataView = ComputeHash.HashableView.of(metadata);
        TreeSet<Entity.Blueprint> all = new TreeSet<Entity.Blueprint>(ComputeHash.BLUEPRINT_COMPARATOR);
        all.addAll(metadata.getMetricTypes());
        all.addAll(metadata.getResourceTypes());
        StringBuilder result = new StringBuilder();
        for (Entity.Blueprint bl : all) {
            ComputeHash.IntermediateHashResult res = ComputeHash.computeHash(null, bl, metadataView, ctor, true, false, false, rp -> null, rp -> null);
            result.append(res.identityHash);
        }
        ComputeHash.DigestComputingWriter digestor = ctor.getDigestor();
        digestor.reset();
        digestor.append(result);
        digestor.close();
        return digestor.digest();
    }

    public static String of(InventoryStructure<?> inventory) {
        return ComputeHash.of(inventory, null, true, false, false).getIdentityHash();
    }

    public static String of(Entity<? extends Entity.Blueprint, ?> entity, Inventory inventory) {
        return IdentityHash.of(InventoryStructure.of(entity, inventory));
    }

    public static String of(MetadataPack mp, Inventory inventory) {
        ArrayList all = new ArrayList();
        all.addAll(((ResourceTypes.Multiple)inventory.inspect(mp).resourceTypes().getAll(new Filter[0])).entities());
        all.addAll(((MetricTypes.Multiple)inventory.inspect(mp).metricTypes().getAll(new Filter[0])).entities());
        return IdentityHash.of(all, inventory);
    }

    public static Tree treeOf(InventoryStructure<?> inventory) {
        Tree.AbstractBuilder[] tbld = new Tree.AbstractBuilder[1];
        Consumer<ComputeHash.IntermediateHashContext> startChild = context -> {
            tbld[0] = tbld[0] == null ? Tree.builder() : (Tree.AbstractBuilder)tbld[0].startChild();
        };
        BiConsumer<ComputeHash.IntermediateHashContext, ComputeHash.IntermediateHashResult> endChild = (ctx, result) -> {
            if (tbld[0] instanceof Tree.ChildBuilder) {
                tbld[0].withHash(result.identityHash).withPath(result.path);
                Tree.AbstractBuilder parent = (Tree.AbstractBuilder)((Tree.ChildBuilder)tbld[0]).getParent();
                parent.addChild(((Tree.ChildBuilder)tbld[0]).build());
                tbld[0] = parent;
            }
        };
        ComputeHash.IntermediateHashResult res = ComputeHash.treeOf(inventory, null, true, false, false, startChild, endChild, p -> null);
        tbld[0].withPath(res.path).withHash((String)res.identityHash);
        return ((Tree.Builder)tbld[0]).build();
    }

    public static String of(Iterable<? extends Entity<? extends Entity.Blueprint, ?>> entities, Inventory inventory) {
        return IdentityHash.of(entities.iterator(), inventory);
    }

    public static String of(Iterator<? extends Entity<? extends Entity.Blueprint, ?>> entities, Inventory inventory) {
        TreeSet sortedEntities = new TreeSet(ComputeHash.ENTITY_COMPARATOR);
        entities.forEachRemaining(sortedEntities::add);
        ComputeHash.HashConstructor ctor = new ComputeHash.HashConstructor(new ComputeHash.DigestComputingWriter(ComputeHash.newDigest()));
        StringBuilder resultHash = new StringBuilder();
        sortedEntities.forEach(e -> {
            InventoryStructure structure = InventoryStructure.of(e, inventory);
            ComputeHash.HashableView v = ComputeHash.HashableView.of(structure);
            ComputeHash.IntermediateHashResult res = ComputeHash.computeHash(e.getPath(), structure.getRoot(), v, ctor, true, false, false, rp -> null, rp -> null);
            resultHash.append(res.identityHash);
        });
        ctor.getDigestor().reset();
        ctor.getDigestor().append(resultHash);
        ctor.getDigestor().close();
        return ctor.getDigestor().digest();
    }

    @ApiModel(value="IdentityHashTree")
    public static final class Tree
    extends AbstractHashTree<Tree, String>
    implements Serializable {
        private Tree() {
            this(null, null, null);
        }

        private Tree(RelativePath path, String hash, Map<Path.Segment, Tree> children) {
            super(path, hash, children);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class ChildBuilder<Parent extends AbstractHashTree.Builder<Parent, ChildBuilder<Parent>, Tree, String> & AbstractBuilder<Parent>>
        extends AbstractHashTree.AbstractChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, String>
        implements AbstractBuilder<ChildBuilder<Parent>>,
        AbstractHashTree.ChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, String> {
            ChildBuilder(AbstractHashTree.TreeConstructor<Tree, String> tctor, Parent p) {
                super(tctor, p, ChildBuilder::new);
            }
        }

        public static final class Builder
        extends AbstractHashTree.AbstractBuilder<Builder, ChildBuilder<Builder>, Tree, String>
        implements AbstractBuilder<Builder>,
        AbstractHashTree.TopBuilder<Builder, ChildBuilder<Builder>, Tree, String> {
            private Builder() {
                super((x$0, x$1, x$2) -> new Tree(x$0, (String)((Object)x$1), x$2), ChildBuilder::new);
            }

            @Override
            public Tree build() {
                return (Tree)super.build();
            }
        }

        public static interface AbstractBuilder<This extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, String> & AbstractBuilder<This>>
        extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, String> {
        }
    }
}

