/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Synced;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.SyncConfiguration;
import org.hawkular.inventory.api.model.SyncHash;
import org.hawkular.inventory.api.model.SyncRequest;
import org.hawkular.inventory.api.model.Syncable;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.BaseEnvironments;
import org.hawkular.inventory.base.BaseFeeds;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseOperationTypes;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.BaseTenants;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

abstract class SingleSyncedFetcher<BE, E extends Entity<B, U>, B extends Entity.Blueprint, U extends Entity.Update>
extends SingleEntityFetcher<BE, E, U>
implements Synced.SingleWithRelationships<E, B, U> {
    SingleSyncedFetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    @Override
    public void synchronize(SyncRequest<B> syncRequest) {
        this.inTx(tx -> {
            Object root = tx.querySingle(this.context.select().get());
            boolean rootFullyInitialized = true;
            if (root == null) {
                Mutator mutator = this.createMutator(tx);
                EntityAndPendingNotifications<BE, E> res = mutator.doCreate(syncRequest.getInventoryStructure().getRoot(), tx);
                root = res.getEntityRepresentation();
                rootFullyInitialized = false;
            }
            CanonicalPath rootPath = tx.extractCanonicalPath(root);
            Map.Entry<InventoryStructure<B>, SyncHash.Tree> structAndTree = rootFullyInitialized ? this.treeHashAndStructure(tx) : new AbstractMap.SimpleImmutableEntry(InventoryStructure.of(syncRequest.getInventoryStructure().getRoot()).build(), SyncHash.Tree.builder().build());
            SyncHash.Tree currentTree = structAndTree.getValue();
            InventoryStructure<B> currentStructure = structAndTree.getKey();
            InventoryStructure<B> newStructure = this.mergeTree(currentStructure, syncRequest.getInventoryStructure(), syncRequest.getConfiguration());
            SyncHash.Tree newTree = SyncHash.treeOf(newStructure, rootPath);
            this.syncTrees(tx, rootPath, root, currentTree, newTree, newStructure);
            return null;
        });
    }

    @Override
    public SyncHash.Tree treeHash() {
        return this.inTx(tx -> this.treeHashAndStructure(tx).getValue());
    }

    private InventoryStructure<B> mergeTree(InventoryStructure<B> currentTree, InventoryStructure<B> newTree, SyncConfiguration configuration) {
        if (configuration.isDeepSearch()) {
            return this.mergeDeepTree(InventoryStructure.Offline.copy(currentTree).asBuilder(), InventoryStructure.Offline.copy(newTree).asBuilder(), configuration.getSyncedTypes()).build();
        }
        return this.mergeShallowTree(InventoryStructure.Offline.copy(currentTree).asBuilder(), InventoryStructure.Offline.copy(newTree).asBuilder(), configuration.getSyncedTypes()).build();
    }

    private InventoryStructure.Builder<B> mergeShallowTree(InventoryStructure.AbstractBuilder<?> currentTree, InventoryStructure.AbstractBuilder<?> newTree, Set<SegmentType> mergedTypes) {
        Set<Path.Segment> currentChildPaths = currentTree.getChildrenPaths();
        Set<Path.Segment> newChildPaths = newTree.getChildrenPaths();
        for (Path.Segment ccp : currentChildPaths) {
            if (newChildPaths.contains(ccp)) {
                this.mergeShallowTree(currentTree.getChild(ccp), newTree.getChild(ccp), mergedTypes);
                continue;
            }
            if (mergedTypes.contains(ccp.getElementType())) continue;
            newTree.addChild(currentTree.getChild(ccp), true);
        }
        if (newTree instanceof InventoryStructure.Builder) {
            return (InventoryStructure.Builder)newTree;
        }
        return null;
    }

    private InventoryStructure.Builder<B> mergeDeepTree(InventoryStructure.AbstractBuilder<?> currentTree, InventoryStructure.AbstractBuilder<?> newTree, Set<SegmentType> mergedTypes) {
        Set<Path.Segment> currentChildPaths = currentTree.getChildrenPaths();
        Set<Path.Segment> newChildPaths = newTree.getChildrenPaths();
        for (Path.Segment ccp : currentChildPaths) {
            if (newChildPaths.contains(ccp)) {
                this.mergeDeepTree(currentTree.getChild(ccp), newTree.getChild(ccp), mergedTypes);
                continue;
            }
            if (mergedTypes.contains(ccp.getElementType())) continue;
            newTree.addChild(currentTree.getChild(ccp).getBlueprint());
            this.mergeDeepTree(currentTree.getChild(ccp), newTree.getChild(ccp), mergedTypes);
        }
        if (newTree instanceof InventoryStructure.Builder) {
            return (InventoryStructure.Builder)newTree;
        }
        return null;
    }

    private void syncTrees(Transaction<BE> tx, CanonicalPath root, BE oldElement, SyncHash.Tree oldTree, SyncHash.Tree newTree, InventoryStructure<?> newStructure) {
        if (!Objects.equals(oldTree.getHash(), newTree.getHash())) {
            Blueprint newState = newStructure.get(newTree.getPath());
            Entity.Update entityUpdate = this.updateFromBlueprint(newState);
            BaseInventory inv = this.context.inventory.keepTransaction(tx);
            inv.inspect(tx.extractCanonicalPath(oldElement), ResolvableToSingle.class).update(entityUpdate);
            Set<SyncHash.Tree> unprocessedChildren = this.sortByType(newTree.getChildren());
            HashMap<SyncHash.Tree, SyncHash.Tree> updates = new HashMap<SyncHash.Tree, SyncHash.Tree>();
            Map<InventoryStructure.EntityType, Set<SyncHash.Tree>> childrenByType = SingleSyncedFetcher.splitByType(oldTree.getChildren());
            for (InventoryStructure.EntityType type : InventoryStructure.EntityType.values()) {
                Set<SyncHash.Tree> oldChildren = childrenByType.get((Object)type);
                if (oldChildren == null) continue;
                for (SyncHash.Tree oldChild : oldChildren) {
                    SyncHash.Tree newChild = (SyncHash.Tree)newTree.getChild(oldChild.getPath().getSegment());
                    if (newChild == null) {
                        CanonicalPath childCp = oldChild.getPath().applyTo(root);
                        try {
                            inv.inspect(childCp, ResolvableToSingle.class).delete();
                        }
                        catch (EntityNotFoundException e) {
                            Log.LOGGER.debug("Failed to find a child to be deleted on canonical path " + childCp + ". Ignoring this since we were going to delete it anyway.", e);
                        }
                        continue;
                    }
                    unprocessedChildren.remove(newChild);
                    updates.put(oldChild, newChild);
                }
            }
            unprocessedChildren.forEach(c -> this.create(tx, root, (SyncHash.Tree)c, newStructure));
            for (Map.Entry entry : updates.entrySet()) {
                SyncHash.Tree oldChild = (SyncHash.Tree)entry.getKey();
                SyncHash.Tree update = (SyncHash.Tree)entry.getValue();
                CanonicalPath childCp = update.getPath().applyTo(root);
                try {
                    BE child = tx.find(childCp);
                    this.syncTrees(tx, root, child, oldChild, update, newStructure);
                }
                catch (ElementNotFoundException ex) {
                    Log.LOGGER.debug("Failed to find entity on " + childCp + " that we thought was there. Never mind " + "though, we can just create it again.", ex);
                    this.create(tx, root, update, newStructure);
                }
            }
        }
    }

    private Set<SyncHash.Tree> sortByType(Collection<SyncHash.Tree> col) {
        TreeSet<SyncHash.Tree> set = new TreeSet<SyncHash.Tree>((a, b) -> {
            InventoryStructure.EntityType aType = InventoryStructure.EntityType.of(a.getPath().getSegment().getElementType());
            InventoryStructure.EntityType bType = InventoryStructure.EntityType.of(b.getPath().getSegment().getElementType());
            int ret = aType.ordinal() - bType.ordinal();
            if (ret == 0) {
                ret = ((String)a.getHash()).compareTo((String)b.getHash());
            }
            return ret;
        });
        set.addAll(col);
        return set;
    }

    private void create(Transaction<BE> tx, CanonicalPath root, SyncHash.Tree tree, InventoryStructure<?> newStructure) {
        BaseInventory inv = this.context.inventory.keepTransaction(tx);
        CanonicalPath childCp = tree.getPath().applyTo(root);
        final ResolvableToSingle parentAccess = inv.inspect(childCp.up(), ResolvableToSingle.class);
        final Blueprint blueprint = newStructure.get(tree.getPath());
        if (blueprint == null) {
            return;
        }
        childCp.getSegment().accept((ElementTypeVisitor)new ElementTypeVisitor.Simple<Void, Void>(){

            public Void visitFeed(Void parameter) {
                ((Feeds.ReadWrite)((Feeds.Container)((Object)parentAccess)).feeds()).create((Feed.Blueprint)blueprint);
                return null;
            }

            public Void visitMetric(Void parameter) {
                ((Metrics.ReadWrite)((Metrics.Container)((Object)parentAccess)).metrics()).create((Metric.Blueprint)blueprint);
                return null;
            }

            public Void visitMetricType(Void parameter) {
                ((MetricTypes.ReadWrite)((MetricTypes.Container)((Object)parentAccess)).metricTypes()).create((MetricType.Blueprint)blueprint);
                return null;
            }

            public Void visitResource(Void parameter) {
                ((Resources.ReadWrite)((Resources.Container)((Object)parentAccess)).resources()).create((Resource.Blueprint)blueprint);
                return null;
            }

            public Void visitResourceType(Void parameter) {
                ((ResourceTypes.ReadWrite)((ResourceTypes.Container)((Object)parentAccess)).resourceTypes()).create((ResourceType.Blueprint)blueprint);
                return null;
            }

            public Void visitData(Void parameter) {
                ((Data.ReadWrite)((Data.Container)((Object)parentAccess)).data()).create((DataEntity.Blueprint)blueprint);
                return null;
            }

            public Void visitOperationType(Void parameter) {
                ((OperationTypes.ReadWrite)((OperationTypes.Container)((Object)parentAccess)).operationTypes()).create((OperationType.Blueprint)blueprint);
                return null;
            }
        }, null);
        for (SyncHash.Tree child : tree.getChildren()) {
            this.create(tx, root, child, newStructure);
        }
    }

    private Entity.Update updateFromBlueprint(Blueprint blueprint) {
        return blueprint.accept(new ElementBlueprintVisitor.Simple<Entity.Update, Void>(){

            @Override
            public DataEntity.Update visitData(DataEntity.Blueprint<?> data, Void parameter) {
                return this.fillCommon(DataEntity.Update.builder(), data).withValue(data.getValue()).build();
            }

            @Override
            public Feed.Update visitFeed(Feed.Blueprint feed, Void parameter) {
                return this.fillCommon(Feed.Update.builder(), feed).build();
            }

            @Override
            public Metric.Update visitMetric(Metric.Blueprint metric, Void parameter) {
                return this.fillCommon(Metric.Update.builder(), metric).withInterval(metric.getCollectionInterval()).build();
            }

            @Override
            public MetricType.Update visitMetricType(MetricType.Blueprint type, Void parameter) {
                return this.fillCommon(MetricType.Update.builder(), type).withInterval(type.getCollectionInterval()).build();
            }

            @Override
            public OperationType.Update visitOperationType(OperationType.Blueprint operationType, Void parameter) {
                return this.fillCommon(OperationType.Update.builder(), operationType).build();
            }

            @Override
            public Resource.Update visitResource(Resource.Blueprint resource, Void parameter) {
                return this.fillCommon(Resource.Update.builder(), resource).build();
            }

            @Override
            public ResourceType.Update visitResourceType(ResourceType.Blueprint type, Void parameter) {
                return this.fillCommon(ResourceType.Update.builder(), type).build();
            }

            private <UU extends Entity.Update, Bld extends Entity.Update.Builder<UU, Bld>> Bld fillCommon(Bld bld, Entity.Blueprint bl) {
                if (bl.getProperties() != null) {
                    bld.withProperties(bl.getProperties());
                }
                return bld.withName(bl.getName());
            }
        }, null);
    }

    private Map.Entry<InventoryStructure<B>, SyncHash.Tree> treeHashAndStructure(Transaction<BE> tx) {
        BE root = tx.querySingle(this.context.select().get());
        Entity entity = (Entity)tx.convert(root, this.context.entityClass);
        SyncHash.Tree.Builder bld = SyncHash.Tree.builder();
        InventoryStructure.Builder<Entity.Blueprint> structBld = InventoryStructure.of((Entity.Blueprint)Inventory.asBlueprint(entity));
        ((SyncHash.Tree.Builder)bld.withPath(RelativePath.empty().get())).withHash(((Syncable)((Object)entity)).getSyncHash());
        Iterator<BE> closure = tx.getTransitiveClosureOver(root, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name());
        if (closure.hasNext()) {
            Function<Object, Entity> convert = e -> (Entity)tx.convert(e, tx.extractType(e));
            Stream<BE> st = StreamSupport.stream(Spliterators.spliteratorUnknownSize(closure, 0), false);
            Iterator<Entity<Entity.Blueprint, ?>> entities = st.map(convert).iterator();
            this.buildChildTree(tx, entity.getPath(), Collections.singletonList(bld), Collections.singletonList(structBld), new ArrayList(), new ArrayList(), (Entity)entities.next(), entities);
        }
        return new AbstractMap.SimpleImmutableEntry<InventoryStructure<B>, SyncHash.Tree>(structBld.build(), bld.build());
    }

    private void buildChildTree(Transaction<BE> tx, CanonicalPath root, List<? extends SyncHash.Tree.AbstractBuilder<?>> possibleTreeParents, List<? extends InventoryStructure.AbstractBuilder<?>> possibleStructParents, List<SyncHash.Tree.ChildBuilder<?>> currentTreeRow, List<InventoryStructure.ChildBuilder<?>> currentStructRow, Entity<? extends Entity.Blueprint, ?> currentElement, Iterator<Entity<? extends Entity.Blueprint, ?>> nextElements) {
        Consumer<Entity> decider = e -> {
            if (!(e instanceof Syncable)) {
                return;
            }
            CanonicalPath currentPath = e.getPath();
            RelativePath relativeCurrentPath = currentPath.relativeTo(root);
            SyncHash.Tree.AbstractBuilder<?> treeParent = SingleSyncedFetcher.findTreeParent(possibleTreeParents, relativeCurrentPath);
            InventoryStructure.AbstractBuilder<?> structParent = SingleSyncedFetcher.findStructParent(possibleStructParents, relativeCurrentPath);
            if (treeParent == null && structParent != null || treeParent != null && structParent == null) {
                throw new IllegalStateException("Inconsistent tree hash and inventory structure builders while computing the child tree of entity " + root + ". This is a bug.");
            }
            if (treeParent == null) {
                possibleTreeParents.forEach(p -> {
                    if (p instanceof SyncHash.Tree.ChildBuilder) {
                        ((SyncHash.Tree.ChildBuilder)p).endChild();
                    }
                });
                possibleStructParents.forEach(p -> {
                    if (p instanceof InventoryStructure.ChildBuilder) {
                        ((InventoryStructure.ChildBuilder)p).end();
                    }
                });
                this.buildChildTree(tx, root, (List<? extends SyncHash.Tree.AbstractBuilder<?>>)currentTreeRow, (List<? extends InventoryStructure.AbstractBuilder<?>>)currentStructRow, new ArrayList(), new ArrayList(), (Entity<? extends Entity.Blueprint, ?>)e, (Iterator<Entity<? extends Entity.Blueprint, ?>>)nextElements);
            } else {
                SyncHash.Tree.ChildBuilder childTreeBuilder = (SyncHash.Tree.ChildBuilder)treeParent.startChild();
                childTreeBuilder.withHash(((Syncable)((Object)e)).getSyncHash());
                childTreeBuilder.withPath(relativeCurrentPath);
                currentTreeRow.add(childTreeBuilder);
                InventoryStructure.ChildBuilder<?> childStructBuilder = structParent.startChild((Entity.Blueprint)Inventory.asBlueprint(e));
                currentStructRow.add(childStructBuilder);
            }
        };
        decider.accept(currentElement);
        while (nextElements.hasNext()) {
            decider.accept(nextElements.next());
        }
        for (SyncHash.Tree.ChildBuilder<?> childBuilder : currentTreeRow) {
            childBuilder.endChild();
        }
        for (InventoryStructure.ChildBuilder childBuilder : currentStructRow) {
            childBuilder.end();
        }
    }

    private static SyncHash.Tree.AbstractBuilder<?> findTreeParent(List<? extends SyncHash.Tree.AbstractBuilder<?>> possibleParents, RelativePath childPath) {
        return possibleParents.stream().filter(p -> p.getPath().isParentOf(childPath) && p.getPath().getDepth() == childPath.getDepth() - 1).findAny().orElse(null);
    }

    private static InventoryStructure.AbstractBuilder<?> findStructParent(List<? extends InventoryStructure.AbstractBuilder<?>> possibleParents, RelativePath childPath) {
        return possibleParents.stream().filter(p -> p.getPath().isParentOf(childPath) && p.getPath().getDepth() == childPath.getDepth() - 1).findAny().orElse(null);
    }

    private static Map<InventoryStructure.EntityType, Set<SyncHash.Tree>> splitByType(Collection<SyncHash.Tree> group) {
        EnumMap<InventoryStructure.EntityType, Set<SyncHash.Tree>> ret = new EnumMap<InventoryStructure.EntityType, Set<SyncHash.Tree>>(InventoryStructure.EntityType.class);
        group.forEach(t -> {
            SegmentType elementType = t.getPath().getSegment().getElementType();
            InventoryStructure.EntityType entityType = InventoryStructure.EntityType.of(elementType);
            HashSet<SyncHash.Tree> siblings = (HashSet<SyncHash.Tree>)ret.get((Object)entityType);
            if (siblings == null) {
                siblings = new HashSet<SyncHash.Tree>();
                ret.put(entityType, siblings);
            }
            siblings.add((SyncHash.Tree)t);
        });
        return ret;
    }

    private Mutator<BE, E, B, U, String> createMutator(final Transaction<BE> tx) {
        return (Mutator)ElementTypeVisitor.accept((SegmentType)Inventory.types().byElement(this.context.entityClass).getSegmentType(), (ElementTypeVisitor)new ElementTypeVisitor<Mutator<BE, ?, ?, ?, String>, Void>(){

            public Mutator<BE, ?, ?, ?, String> visitTenant(Void parameter) {
                return new BaseTenants.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitEnvironment(Void parameter) {
                return new BaseEnvironments.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitFeed(Void parameter) {
                return new BaseFeeds.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitMetric(Void parameter) {
                return new BaseMetrics.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitMetricType(Void parameter) {
                return new BaseMetricTypes.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitResource(Void parameter) {
                return new BaseResources.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitResourceType(Void parameter) {
                return new BaseResourceTypes.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitRelationship(Void parameter) {
                throw new IllegalArgumentException("Cannot synchronize relationships. This codepath should have never been allowed and is a bug.");
            }

            public Mutator<BE, ?, ?, ?, String> visitData(Void parameter) {
                Object parent = tx.querySingle(SingleSyncedFetcher.this.context.previous.sourcePath);
                if (parent == null) {
                    throw new EntityNotFoundException(Query.filters(SingleSyncedFetcher.this.context.previous.sourcePath));
                }
                Class<?> parentType = tx.extractType(parent);
                return new BaseData.ReadWrite(SingleSyncedFetcher.this.context.previous, this.dataRoleType(parentType), this.dataModificationChecks(parentType));
            }

            public Mutator<BE, ?, ?, ?, String> visitOperationType(Void parameter) {
                return new BaseOperationTypes.ReadWrite(SingleSyncedFetcher.this.context.previous);
            }

            public Mutator<BE, ?, ?, ?, String> visitMetadataPack(Void parameter) {
                throw new IllegalStateException("Cannot synchronize metadata packs. This codepath should have never been allowed and is a bug.");
            }

            public Mutator<BE, ?, ?, ?, String> visitUnknown(Void parameter) {
                throw new IllegalStateException("This is a bug! Unhandled type of entity for synchronization: " + SingleSyncedFetcher.this.context.entityClass);
            }

            private <E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> Class<? extends DataRole> dataRoleType(Class<E> parentType) {
                SegmentType st = Inventory.types().byElement(parentType).getSegmentType();
                switch (st) {
                    case r: {
                        return DataRole.Resource.class;
                    }
                    case rt: {
                        return DataRole.ResourceType.class;
                    }
                    case ot: {
                        return DataRole.OperationType.class;
                    }
                }
                throw new IllegalStateException("This is a bug! Unhandled data role class for type " + SingleSyncedFetcher.this.context.entityClass);
            }

            private <E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> BaseData.DataModificationChecks<BE> dataModificationChecks(Class<E> parentType) {
                SegmentType st = Inventory.types().byElement(parentType).getSegmentType();
                switch (st) {
                    case r: {
                        return BaseData.DataModificationChecks.none();
                    }
                    case rt: {
                        return new BaseResourceTypes.ResourceTypeDataModificationChecks(SingleSyncedFetcher.this.context.previous);
                    }
                    case ot: {
                        return new BaseOperationTypes.OperationTypeDataModificationChecks(SingleSyncedFetcher.this.context.previous);
                    }
                }
                throw new IllegalStateException("This is a bug! Unhandled data modification checks for type " + SingleSyncedFetcher.this.context.entityClass);
            }
        }, null);
    }
}

