/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionManagerShutdown;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.SecurityActions;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.spi.graceful.GracefulCallback;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Messages;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private final CoreLogger log;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Pool pool;
    private String securityDomain;
    private SubjectFactory subjectFactory;
    private FlushStrategy flushStrategy;
    private int allocationRetry;
    private long allocationRetryWaitMillis;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService = null;
    private ScheduledFuture scheduledGraceful = null;
    private GracefulCallback gracefulCallback = null;
    private CachedConnectionManager cachedConnectionManager;
    private String jndiName;
    private boolean sharable;
    protected boolean enlistment;
    protected boolean connectable;
    protected Boolean tracking;
    protected Boolean enlistmentTrace;

    protected AbstractConnectionManager() {
        this.log = this.getLogger();
    }

    protected abstract CoreLogger getLogger();

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    public void setCachedConnectionManager(CachedConnectionManager cachedConnectionManager) {
        this.cachedConnectionManager = cachedConnectionManager;
    }

    @Override
    public CachedConnectionManager getCachedConnectionManager() {
        return this.cachedConnectionManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelShutdown() {
        if (this.scheduledGraceful != null) {
            boolean result = this.scheduledGraceful.cancel(false);
            if (!result) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            if (this.pool != null) {
                this.pool.cancelShutdown();
            }
            this.scheduledGraceful = null;
            this.gracefulCallback = null;
            return true;
        } else {
            if (!this.shutdown.get()) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            if (this.pool != null) {
                this.pool.cancelShutdown();
            }
            this.gracefulCallback = null;
        }
        return true;
    }

    public void prepareShutdown() {
        this.prepareShutdown(0, null);
    }

    public void prepareShutdown(GracefulCallback cb) {
        this.prepareShutdown(0, cb);
    }

    public void prepareShutdown(int seconds) {
        this.prepareShutdown(seconds, null);
    }

    public void prepareShutdown(int seconds, GracefulCallback cb) {
        this.shutdown.set(true);
        if (this.gracefulCallback == null) {
            this.gracefulCallback = cb;
        }
        if (this.pool != null) {
            this.pool.prepareShutdown();
        }
        if (seconds > 0) {
            if (this.scheduledGraceful == null) {
                if (this.scheduledExecutorService == null) {
                    this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
                }
                this.scheduledGraceful = this.scheduledExecutorService.schedule(new ConnectionManagerShutdown(this), (long)seconds, TimeUnit.SECONDS);
            }
        } else if (this.pool != null && this.pool.isIdle()) {
            this.shutdown();
        }
    }

    public synchronized void shutdown() {
        this.getLogger().debugf("%s: shutdown", this.jndiName);
        this.shutdown.set(true);
        if (this.pool != null) {
            this.pool.shutdown();
        }
        if (this.scheduledExecutorService != null) {
            if (this.scheduledGraceful != null && !this.scheduledGraceful.isDone()) {
                this.scheduledGraceful.cancel(true);
            }
            this.scheduledGraceful = null;
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
        if (this.gracefulCallback != null) {
            this.gracefulCallback.done();
            this.gracefulCallback = null;
        }
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public int getDelay() {
        if (this.scheduledGraceful != null) {
            return (int)this.scheduledGraceful.getDelay(TimeUnit.SECONDS);
        }
        if (this.shutdown.get()) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public boolean isSharable() {
        return this.sharable;
    }

    public void setSharable(boolean v) {
        this.sharable = v;
        this.log.tracef("sharable=%s", this.sharable);
    }

    @Override
    public boolean isEnlistment() {
        return this.enlistment;
    }

    public void setEnlistment(boolean v) {
        this.enlistment = v;
        this.log.tracef("enlistment=%s", this.enlistment);
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean v) {
        this.connectable = v;
        this.log.tracef("connectable=%s", this.connectable);
    }

    public Boolean getTracking() {
        return this.tracking;
    }

    public void setTracking(Boolean v) {
        this.tracking = v;
        this.log.tracef("tracking=%s", this.tracking);
    }

    public Boolean getEnlistmentTrace() {
        return this.enlistmentTrace;
    }

    public void setEnlistmentTrace(Boolean v) {
        this.enlistmentTrace = v;
        this.log.tracef("enlistment_trace=%s", this.enlistmentTrace);
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public void setFlushStrategy(FlushStrategy v) {
        this.flushStrategy = v;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        if (this.pool == null) {
            this.log.tracef("No pooling strategy found! for connection manager : %s", this);
            return null;
        }
        return this.pool.getManagedConnectionFactory();
    }

    public void setAllocationRetry(int number) {
        if (number >= 0) {
            this.allocationRetry = number;
        }
    }

    @Override
    public int getAllocationRetry() {
        return this.allocationRetry;
    }

    public void setAllocationRetryWaitMillis(long millis) {
        if (millis > 0L) {
            this.allocationRetryWaitMillis = millis;
        }
    }

    @Override
    public long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.getManagedConnection(null, subject, cri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Throwable failure = null;
        if (this.shutdown.get()) {
            throw new ResourceException(bundle.connectionManagerIsShutdown(this.jndiName));
        }
        boolean isInterrupted = Thread.interrupted();
        boolean innerIsInterrupted = false;
        try {
            ConnectionListener connectionListener = this.pool.getConnection(transaction, subject, cri);
            return connectionListener;
        }
        catch (ResourceException e) {
            failure = e;
            if (this.allocationRetry != 0 || e instanceof RetryableException) {
                int to = this.allocationRetry;
                if (this.allocationRetry == 0 && e instanceof RetryableException) {
                    to = 1;
                }
                for (int i = 0; i < to; ++i) {
                    if (this.shutdown.get()) {
                        throw new ResourceException(bundle.connectionManagerIsShutdown(this.jndiName));
                    }
                    this.log.tracef("%s: Attempting allocation retry (%s, %s, %s)", new Object[]{this.jndiName, transaction, subject, cri});
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                        innerIsInterrupted = true;
                    }
                    try {
                        if (this.allocationRetryWaitMillis != 0L) {
                            Thread.sleep(this.allocationRetryWaitMillis);
                        }
                        ConnectionListener connectionListener = this.pool.getConnection(transaction, subject, cri);
                        return connectionListener;
                    }
                    catch (ResourceException re) {
                        failure = re;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        failure = ie;
                        innerIsInterrupted = true;
                    }
                    {
                        continue;
                    }
                }
            }
        }
        catch (Exception e) {
            failure = e;
            return failure;
        }
        finally {
            if (isInterrupted || innerIsInterrupted) {
                Thread.currentThread().interrupt();
                if (innerIsInterrupted) {
                    throw new ResourceException(bundle.getManagedConnectionRetryWaitInterrupted(this.jndiName), failure);
                }
            }
        }
    }

    public void returnManagedConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener bcl, boolean kill) {
        ConnectionListener cl = (ConnectionListener)bcl;
        Pool localStrategy = cl.getPool();
        if (localStrategy != this.pool || this.shutdown.get()) {
            kill = true;
        }
        try {
            if (!kill && cl.getState().equals((Object)ConnectionState.NORMAL)) {
                cl.tidyup();
            }
        }
        catch (Throwable t) {
            this.log.errorDuringTidyUpConnection(cl, t);
            kill = true;
        }
        try {
            localStrategy.returnConnection(cl, kill);
        }
        catch (ResourceException re) {
            if (kill) {
                this.log.debug("ResourceException killing connection", re);
            } else {
                this.log.resourceExceptionReturningConnection(cl.getManagedConnection(), re);
            }
        }
        catch (Exception e) {
            try {
                if (cl.getState().equals((Object)ConnectionState.NORMAL)) {
                    cl.setState(ConnectionState.DESTROY);
                }
                localStrategy.returnConnection(cl, true);
            }
            catch (Throwable t) {
                this.log.throwableReturningConnection(cl.getManagedConnection(), t);
            }
        }
        if (this.shutdown.get() && this.pool.isIdle()) {
            this.shutdown();
        }
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.pool == null || this.shutdown.get()) {
            throw new ResourceException(bundle.tryingUseConnectionFactoryShutDown(this.jndiName));
        }
        if (!this.pool.getManagedConnectionFactory().equals((Object)mcf)) {
            throw new ResourceException(bundle.wrongManagedConnectionFactorySentToAllocateConnection(this.pool.getManagedConnectionFactory(), mcf));
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        Object connection = null;
        try {
            connection = cl.getManagedConnection().getConnection(subject, cri);
        }
        catch (Throwable t) {
            try {
                this.managedConnectionDisconnected(cl);
            }
            catch (ResourceException re) {
                this.log.tracef("Get exception from managedConnectionDisconnected, maybe delist() have problem %s", (Object)re);
                this.returnManagedConnection(cl, true);
            }
            throw new ResourceException(bundle.uncheckedThrowableInManagedConnectionGetConnection(cl), t);
        }
        this.registerAssociation(cl, connection);
        if (this.cachedConnectionManager != null) {
            this.cachedConnectionManager.registerConnection((ConnectionCacheListener)this, (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)cl, connection);
        }
        return connection;
    }

    public void associateConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        this.associateManagedConnection(connection, mcf, cri);
    }

    public ManagedConnection associateManagedConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.pool == null || this.shutdown.get()) {
            throw new ResourceException(bundle.tryingUseConnectionFactoryShutDown(this.jndiName));
        }
        if (!this.pool.getManagedConnectionFactory().equals((Object)mcf)) {
            throw new ResourceException(bundle.wrongManagedConnectionFactorySentToAllocateConnection(this.pool.getManagedConnectionFactory(), mcf));
        }
        if (connection == null) {
            throw new ResourceException(bundle.connectionIsNull());
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        cl.getManagedConnection().associateConnection(connection);
        this.registerAssociation(cl, connection);
        if (this.cachedConnectionManager != null) {
            this.cachedConnectionManager.registerConnection((ConnectionCacheListener)this, (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)cl, connection);
        }
        return cl.getManagedConnection();
    }

    public boolean dissociateManagedConnection(Object connection, ManagedConnection mc, ManagedConnectionFactory mcf) throws ResourceException {
        if (connection == null || mc == null || mcf == null) {
            throw new ResourceException(bundle.unableToFindConnectionListener());
        }
        ConnectionListener cl = this.getPool().findConnectionListener(mc, connection);
        if (cl != null) {
            this.log.tracef("DissociateManagedConnection: cl=%s, connection=%s", cl, connection);
            if (this.getCachedConnectionManager() != null) {
                try {
                    this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this, (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)cl, connection);
                }
                catch (Throwable t) {
                    this.log.debug("Throwable from unregisterConnection", t);
                }
            }
            this.unregisterAssociation(cl, connection);
            if (cl.getNumberOfConnections() == 0) {
                this.log.tracef("DissociateManagedConnection: Returning cl=%s", cl);
                cl.dissociate();
                this.log.tracef("DissociateManagedConnection: isManagedConnectionFree=%s", cl.isManagedConnectionFree());
                if (cl.isManagedConnectionFree()) {
                    this.returnManagedConnection(cl, false);
                    return true;
                }
            }
        } else {
            throw new ResourceException(bundle.unableToFindConnectionListener());
        }
        return false;
    }

    public void inactiveConnectionClosed(Object connection, ManagedConnectionFactory mcf) {
    }

    @Override
    public void unregisterAssociation(ConnectionListener cl, Object c) {
        cl.unregisterConnection(c);
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
    }

    protected void reconnectManagedConnection(ConnectionListener cl) throws ResourceException {
        try {
            this.managedConnectionReconnected(cl);
        }
        catch (Throwable t) {
            this.disconnectManagedConnection(cl);
            throw new ResourceException(bundle.uncheckedThrowableInManagedConnectionReconnected(cl), t);
        }
    }

    protected void disconnectManagedConnection(ConnectionListener cl) {
        try {
            this.managedConnectionDisconnected(cl);
        }
        catch (Throwable t) {
            this.log.uncheckedThrowableInManagedConnectionDisconnected(cl, t);
        }
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
    }

    private void registerAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.registerConnection(c);
    }

    @Override
    public abstract void transactionStarted(Collection<ConnectionRecord> var1) throws SystemException;

    @Override
    public abstract boolean isTransactional();

    @Override
    public abstract TransactionIntegration getTransactionIntegration();

    private Subject getSubject() {
        Set<PasswordCredential> credentials;
        Subject subject = null;
        if (this.subjectFactory != null && this.securityDomain != null && (credentials = SecurityActions.getPasswordCredentials(subject = SecurityActions.createSubject(this.subjectFactory, this.securityDomain))) != null && credentials.size() > 0) {
            ManagedConnectionFactory pcMcf = this.getManagedConnectionFactory();
            for (PasswordCredential pc : credentials) {
                pc.setManagedConnectionFactory(pcMcf);
            }
        }
        this.log.tracef("Subject: %s", subject);
        return subject;
    }
}

