/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerImpl;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBundleXml;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.runner.IdentityPatchRunner;
import org.jboss.as.patching.runner.PatchContentProvider;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;

public class PatchToolImpl
implements PatchTool {
    private final InstallationManager manager;
    private final InstallationManager.ModificationCompletionCallback callback;
    private final IdentityPatchRunner runner;

    public PatchToolImpl(InstallationManager manager) {
        this.manager = manager;
        this.runner = new IdentityPatchRunner(manager.getInstalledImage());
        this.callback = this.runner;
    }

    @Override
    public List<String> getPatchStreams() throws PatchingException {
        List<InstalledIdentity> installedIdentities = this.manager.getInstalledIdentities();
        if (installedIdentities.size() == 1) {
            return Collections.singletonList(installedIdentities.get(0).getIdentity().getName());
        }
        ArrayList<String> result = new ArrayList<String>(installedIdentities.size());
        for (InstalledIdentity ii : installedIdentities) {
            result.add(ii.getIdentity().getName());
        }
        return result;
    }

    @Override
    public PatchInfo getPatchInfo() throws PatchingException {
        return this.getPatchInfo(null);
    }

    @Override
    public PatchInfo getPatchInfo(String streamName) throws PatchingException {
        try {
            final Identity identity = streamName == null ? this.manager.getDefaultIdentity().getIdentity() : this.manager.getInstalledIdentity(streamName, null).getIdentity();
            final PatchableTarget.TargetInfo info = identity.loadTargetInfo();
            return new PatchInfo(){

                @Override
                public String getVersion() {
                    return identity.getVersion();
                }

                @Override
                public String getCumulativePatchID() {
                    return info.getCumulativePatchID();
                }

                @Override
                public List<String> getPatchIDs() {
                    return info.getPatchIDs();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PatchingHistory getPatchingHistory() throws PatchingException {
        return this.getPatchingHistory(null);
    }

    @Override
    public PatchingHistory getPatchingHistory(String streamName) throws PatchingException {
        InstalledIdentity identity = streamName == null ? this.manager.getDefaultIdentity() : this.manager.getInstalledIdentity(streamName, null);
        return PatchingHistory.Factory.getHistory(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchingResult applyPatch(File file, ContentVerificationPolicy contentPolicy) throws PatchingException {
        PatchingResult patchingResult;
        block11: {
            File patchXml;
            if (file.isDirectory() && (patchXml = new File(file, "patch.xml")).exists()) {
                return this.execute(file, contentPolicy);
            }
            FileInputStream is = new FileInputStream(file);
            try {
                patchingResult = this.applyPatch(is, contentPolicy);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw PatchToolImpl.rethrowException(e);
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
            }
        }
        return patchingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchingResult applyPatch(URL url, ContentVerificationPolicy contentPolicy) throws PatchingException {
        PatchingResult patchingResult;
        block10: {
            InputStream is = url.openStream();
            try {
                patchingResult = this.applyPatch(is, contentPolicy);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PatchingException(e);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
            }
        }
        return patchingResult;
    }

    @Override
    public PatchingResult applyPatch(InputStream is, ContentVerificationPolicy contentPolicy) throws PatchingException {
        return this.applyPatch(null, is, contentPolicy);
    }

    private PatchingResult applyPatch(File parentWorkDir, InputStream is, ContentVerificationPolicy contentPolicy) throws PatchingException {
        File workDir = null;
        try {
            workDir = parentWorkDir == null ? IdentityPatchRunner.createTempDir() : IdentityPatchRunner.createTempDir(parentWorkDir);
            File cachedContent = new File(workDir, "content");
            IoUtils.copy(is, cachedContent);
            ZipUtils.unzip(cachedContent, workDir);
            PatchingResult patchingResult = this.execute(workDir, contentPolicy);
            return patchingResult;
        }
        catch (Exception e) {
            throw PatchToolImpl.rethrowException(e);
        }
        finally {
            if (workDir != null && !IoUtils.recursiveDelete(workDir)) {
                PatchLogger.ROOT_LOGGER.cannotDeleteFile(workDir.getAbsolutePath());
            }
        }
    }

    @Override
    public PatchingResult rollback(String patchId, ContentVerificationPolicy contentPolicy, boolean rollbackTo, boolean resetConfiguration) throws PatchingException {
        return this.rollback(null, patchId, contentPolicy, rollbackTo, resetConfiguration);
    }

    @Override
    public PatchingResult rollback(String streamName, String patchId, ContentVerificationPolicy contentPolicy, boolean rollbackTo, boolean resetConfiguration) throws PatchingException {
        InstalledIdentity targetIdentity = null;
        if (streamName == null) {
            for (InstalledIdentity identity : this.manager.getInstalledIdentities()) {
                if (!identity.getAllInstalledPatches().contains(patchId)) continue;
                if (targetIdentity != null) {
                    throw new PatchingException(PatchLogger.ROOT_LOGGER.patchIdFoundInMoreThanOneStream(patchId, targetIdentity.getIdentity().getName(), identity.getIdentity().getName()));
                }
                targetIdentity = identity;
            }
            if (targetIdentity == null) {
                throw PatchLogger.ROOT_LOGGER.patchNotFoundInHistory(patchId);
            }
        } else {
            targetIdentity = this.manager.getInstalledIdentity(streamName, null);
        }
        InstallationManager.InstallationModification modification = targetIdentity.modifyInstallation(this.runner);
        try {
            return this.runner.rollbackPatch(patchId, contentPolicy, rollbackTo, resetConfiguration, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    @Override
    public PatchingResult rollbackLast(ContentVerificationPolicy contentPolicy, boolean resetConfiguration) throws PatchingException {
        return this.rollbackLast(null, contentPolicy, resetConfiguration);
    }

    @Override
    public PatchingResult rollbackLast(String streamName, ContentVerificationPolicy contentPolicy, boolean resetConfiguration) throws PatchingException {
        InstalledIdentity targetIdentity = streamName == null ? this.manager.getDefaultIdentity() : this.manager.getInstalledIdentity(streamName, null);
        InstallationManager.InstallationModification modification = targetIdentity.modifyInstallation(this.runner);
        try {
            return this.runner.rollbackLast(contentPolicy, resetConfiguration, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PatchingResult execute(File workDir, ContentVerificationPolicy contentPolicy) throws PatchingException, IOException, XMLStreamException {
        File patchBundleXml = new File(workDir, "patches.xml");
        if (patchBundleXml.exists()) {
            FileInputStream patchIs = new FileInputStream(patchBundleXml);
            try {
                BundledPatch bundledPatch = PatchBundleXml.parse(patchIs);
                PatchingResult patchingResult = this.applyPatchBundle(workDir, bundledPatch, contentPolicy);
                return patchingResult;
            }
            finally {
                IoUtils.safeClose(patchIs);
            }
        }
        File patchXml = new File(workDir, "patch.xml");
        PatchMetadataResolver patchResolver = this.parsePatchXml(patchXml);
        Patch patch = patchResolver.resolvePatch(null, null);
        InstalledIdentity installedIdentity = this.manager.getInstalledIdentity(patch.getIdentity().getName(), null);
        String currentVersion = installedIdentity.getIdentity().getVersion();
        if (!"Unknown".equals(currentVersion) && !patch.getIdentity().getVersion().equals(currentVersion)) {
            patchXml = new File(workDir, currentVersion + "-patch.xml");
            if (!patchXml.exists()) {
                throw new PatchingException("The patch does not contain metadata for currently installed " + patch.getIdentity().getName() + " version " + currentVersion);
            }
            patchResolver = this.parsePatchXml(patchXml);
            patch = patchResolver.resolvePatch(null, null);
        }
        return this.apply(patchResolver, PatchContentProvider.DefaultContentProvider.create(workDir), contentPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchMetadataResolver parsePatchXml(File patchXml) throws FileNotFoundException, XMLStreamException, IOException {
        PatchMetadataResolver patchMetadataResolver;
        FileInputStream patchIS = null;
        try {
            patchIS = new FileInputStream(patchXml);
            patchMetadataResolver = PatchXml.parse(patchIS);
        }
        catch (Throwable throwable) {
            IoUtils.safeClose(patchIS);
            throw throwable;
        }
        IoUtils.safeClose(patchIS);
        return patchMetadataResolver;
    }

    protected PatchingResult apply(PatchMetadataResolver patchResolver, PatchContentProvider contentProvider, ContentVerificationPolicy contentPolicy) throws PatchingException {
        org.jboss.as.patching.metadata.Identity identity = patchResolver.resolvePatch(null, null).getIdentity();
        InstallationManager.InstallationModification modification = ((InstallationManagerImpl)this.manager).getInstalledIdentity(identity.getName(), identity.getVersion()).modifyInstallation(this.callback);
        try {
            return this.runner.applyPatch(patchResolver, contentProvider, contentPolicy, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    protected PatchingResult applyPatchBundle(File workDir, BundledPatch bundledPatch, ContentVerificationPolicy contentPolicy) throws PatchingException, IOException {
        List<BundledPatch.BundledPatchEntry> patches = bundledPatch.getPatches();
        if (patches.isEmpty()) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.patchBundleIsEmpty());
        }
        PatchingResult result = null;
        BundledPatch.BundledPatchEntry lastCommittedEntry = null;
        ArrayList<BundledPatch.BundledPatchEntry> results = new ArrayList<BundledPatch.BundledPatchEntry>(patches.size());
        List<InstalledIdentity> installedIdentities = this.manager.getInstalledIdentities();
        for (BundledPatch.BundledPatchEntry entry : patches) {
            boolean alreadyApplied = false;
            for (InstalledIdentity identity : installedIdentities) {
                if (!identity.getAllInstalledPatches().contains(entry.getPatchId())) continue;
                alreadyApplied = true;
                break;
            }
            if (alreadyApplied) continue;
            if (result != null) {
                result.commit();
                results.add(0, lastCommittedEntry);
            }
            File patch = new File(workDir, entry.getPatchPath());
            FileInputStream is = new FileInputStream(patch);
            PatchingResult currentResult = null;
            try {
                currentResult = this.applyPatch(workDir, is, contentPolicy);
            }
            catch (PatchingException e) {
                for (BundledPatch.BundledPatchEntry committed : results) {
                    try {
                        this.rollback(committed.getPatchId(), contentPolicy, false, false).commit();
                    }
                    catch (PatchingException oe) {
                        PatchLogger.ROOT_LOGGER.debugf(oe, "failed to rollback patch '%s'", committed.getPatchId());
                    }
                }
                throw e;
            }
            finally {
                IoUtils.safeClose(is);
            }
            if (currentResult == null) continue;
            result = currentResult;
            lastCommittedEntry = entry;
        }
        if (result == null) {
            throw new PatchingException();
        }
        return new WrappedMultiInstallPatch(result, contentPolicy, results);
    }

    static PatchingException rethrowException(Exception e) {
        if (e instanceof PatchingException) {
            return (PatchingException)e;
        }
        return new PatchingException(e);
    }

    class WrappedMultiInstallPatch
    implements PatchingResult {
        private final PatchingResult last;
        private final ContentVerificationPolicy policy;
        private final List<BundledPatch.BundledPatchEntry> committed;

        WrappedMultiInstallPatch(PatchingResult last, ContentVerificationPolicy policy, List<BundledPatch.BundledPatchEntry> committed) {
            this.last = last;
            this.policy = policy;
            this.committed = committed;
        }

        @Override
        public String getPatchId() {
            return this.last.getPatchId();
        }

        @Override
        public PatchInfo getPatchInfo() {
            return this.last.getPatchInfo();
        }

        @Override
        public void commit() {
            this.last.commit();
        }

        @Override
        public void rollback() {
            this.last.rollback();
            for (BundledPatch.BundledPatchEntry entry : this.committed) {
                try {
                    PatchToolImpl.this.rollback(entry.getPatchId(), this.policy, false, false).commit();
                }
                catch (Exception e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to rollback patch '%s'", entry.getPatchId());
                }
            }
        }
    }
}

