/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAny<T>
implements Observable.Operator<Boolean, T> {
    private final Func1<? super T, Boolean> predicate;
    private final boolean returnOnEmpty;

    public OperatorAny(Func1<? super T, Boolean> predicate, boolean returnOnEmpty) {
        this.predicate = predicate;
        this.returnOnEmpty = returnOnEmpty;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        Subscriber s = new Subscriber<T>(){
            boolean hasElements;
            boolean done;

            @Override
            public void onNext(T t) {
                this.hasElements = true;
                boolean result = (Boolean)OperatorAny.this.predicate.call(t);
                if (result && !this.done) {
                    this.done = true;
                    child.onNext(!OperatorAny.this.returnOnEmpty);
                    child.onCompleted();
                    this.unsubscribe();
                } else {
                    this.request(1L);
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    if (this.hasElements) {
                        child.onNext(false);
                    } else {
                        child.onNext(OperatorAny.this.returnOnEmpty);
                    }
                    child.onCompleted();
                }
            }
        };
        child.add(s);
        return s;
    }
}

