/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.logging;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.idm.config.SecurityConfigurationException;

@MessageLogger(projectCode="WFLYPL", length=4)
public interface PicketLinkLogger
extends BasicLogger {
    public static final PicketLinkLogger ROOT_LOGGER = (PicketLinkLogger)Logger.getMessageLogger(PicketLinkLogger.class, (String)"org.wildfly.extension.picketlink");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating PicketLink %s Subsystem")
    public void activatingSubsystem(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Configuring PicketLink Federation for deployment [%s]")
    public void federationConfiguringDeployment(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Bound [%s] to [%s]")
    public void boundToJndi(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Ignoring unexpected event type [%s]")
    public void federationIgnoringAuditEvent(PicketLinkAuditEventType var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Error while configuring the metrics collector. Metrics will not be collected.")
    public void federationErrorCollectingMetric(@Cause Throwable var1);

    @Message(id=6, value="No writer provided for element %s. Check if a writer is registered in PicketLinkSubsystemWriter.")
    public IllegalStateException noModelElementWriterProvided(String var1);

    @Message(id=7, value="Could not load module [%s].")
    public RuntimeException moduleCouldNotLoad(String var1, @Cause Throwable var2);

    @Message(id=8, value="Unexpected element [%s].")
    public XMLStreamException parserUnexpectedElement(String var1);

    @Message(id=9, value="Could not load class [%s].")
    public RuntimeException couldNotLoadClass(String var1, @Cause Throwable var2);

    @Message(id=10, value="No type provided for %s. You must specify a class-name or code.")
    public OperationFailedException typeNotProvided(String var1);

    @Message(id=11, value="Failed to get metrics %s.")
    public OperationFailedException failedToGetMetrics(String var1);

    @Message(id=12, value="Attribute [%s] is not longer supported.")
    public OperationFailedException attributeNoLongerSupported(String var1);

    @Message(id=13, value="[%s] can only have [%d] child of type [%s].")
    public OperationFailedException invalidChildTypeOccurrence(String var1, int var2, String var3);

    @Message(id=14, value="Invalid attribute [%s] definition for [%s]. Only one of the following attributes are allowed: [%s].")
    public OperationFailedException invalidAlternativeAttributeOccurrence(String var1, String var2, String var3);

    @Message(id=15, value="Required attribute [%s] for [%s].")
    public OperationFailedException requiredAttribute(String var1, String var2);

    @Message(id=16, value="[%s] requires one of the given attributes [%s].")
    public OperationFailedException requiredAlternativeAttributes(String var1, String var2);

    @Message(id=17, value="Type [%s] already defined.")
    public IllegalStateException typeAlreadyDefined(String var1);

    @Message(id=18, value="[%s] can not be empty.")
    public OperationFailedException emptyResource(String var1);

    @Message(id=19, value="[%s] requires child [%s].")
    public OperationFailedException requiredChild(String var1, String var2);

    @Message(id=50, value="Entities module not found [%s].")
    public SecurityConfigurationException idmJpaEntityModuleNotFound(String var1);

    @Message(id=51, value="Could not configure JPA store.")
    public SecurityConfigurationException idmJpaStartFailed(@Cause Throwable var1);

    @Message(id=52, value="Could not lookup EntityManagerFactory [%s].")
    public SecurityConfigurationException idmJpaEMFLookupFailed(String var1);

    @Message(id=53, value="Could not create transactional EntityManager.")
    public SecurityConfigurationException idmJpaFailedCreateTransactionEntityManager(@Cause Exception var1);

    @Message(id=54, value="You must provide at least one identity configuration.")
    public OperationFailedException idmNoIdentityConfigurationProvided();

    @Message(id=55, value="You must provide at least one identity store for identity configuration [%s].")
    public OperationFailedException idmNoIdentityStoreProvided(String var1);

    @Message(id=56, value="No supported type provided.")
    public OperationFailedException idmNoSupportedTypesDefined();

    @Message(id=57, value="No mapping was defined.")
    public OperationFailedException idmLdapNoMappingDefined();

    @Message(id=100, value="No Identity Provider configuration found for federation [%s]. ")
    public IllegalStateException federationIdentityProviderNotConfigured(String var1);

    @Message(id=101, value="No type provided for the handler. You must specify a class-name or code.")
    public OperationFailedException federationHandlerTypeNotProvided();

    @Message(id=102, value="Could not parse default STS configuration.")
    public RuntimeException federationCouldNotParseSTSConfig(@Cause Throwable var1);

    @Message(id=104, value="Could not configure SAML Metadata to deployment [%s].")
    public IllegalStateException federationSAMLMetadataConfigError(String var1, @Cause ProcessingException var2);
}

