/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient.modules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.hawkular.dmrclient.modules.AddModuleRequest;

public class Modules {
    static final String JBOSS_HOME_ENV_VAR = "JBOSS_HOME_ENV_VAR";
    static final String JBOSS_HOME_PROPERTY = "jboss.home.dir";
    private final File modulesDir;

    public static File findModulesDir() {
        String jbossHomeStr = System.getenv(JBOSS_HOME_ENV_VAR);
        if (jbossHomeStr == null) {
            jbossHomeStr = System.getProperty(JBOSS_HOME_PROPERTY, null);
        }
        if (jbossHomeStr == null) {
            throw new IllegalStateException("JBOSS_HOME_ENV_VAR environment variable is not set.");
        }
        File modulesDir = new File(jbossHomeStr, "modules");
        if (!modulesDir.exists()) {
            throw new IllegalStateException("Failed to locate the modules dir on the filesystem: " + modulesDir.getAbsolutePath());
        }
        return modulesDir;
    }

    public Modules(File modulesDir) {
        this.modulesDir = modulesDir;
    }

    public void add(AddModuleRequest addModuleRequest) throws Exception {
        this.validate(addModuleRequest);
        String moduleName = addModuleRequest.getModuleName();
        File moduleDir = this.getModulePath(moduleName, addModuleRequest.getSlot());
        if (!moduleDir.mkdirs()) {
            throw new IllegalStateException("Failed to create directory [" + moduleDir.getAbsolutePath() + "]");
        }
        File moduleXmlPath = new File(moduleDir, "module.xml");
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(moduleXmlPath), "utf-8");){
            this.writeModuleXml(w, addModuleRequest);
        }
        this.copyResources(addModuleRequest, moduleDir);
    }

    void copyResources(AddModuleRequest addModuleRequest, File moduleDir) throws IOException {
        for (AddModuleRequest.ModuleResource resource : addModuleRequest.getResources()) {
            File destFile = new File(moduleDir, resource.getFileName());
            Files.copy(resource.getInput(), destFile.toPath(), new CopyOption[0]);
        }
    }

    File getModulePath(String moduleName, String slot) {
        return new File(this.modulesDir, moduleName.replace('.', File.separatorChar) + File.separatorChar + (slot == null ? "main" : slot));
    }

    public void remove(String moduleName, String slot) throws Exception {
        File modulePath = this.getModulePath(moduleName, slot);
        this.deleteDirectory(modulePath);
    }

    private void deleteDirectory(File dir) throws IOException {
        if (dir != null && dir.exists()) {
            File[] doomedFiles;
            if (dir.isDirectory() && (doomedFiles = dir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    this.deleteDirectory(doomedFile);
                }
            }
            if (!dir.delete()) {
                throw new IOException("Cannot delete: " + dir);
            }
        }
    }

    void validate(AddModuleRequest addModuleRequest) throws IllegalArgumentException {
        if (!this.modulesDir.exists()) {
            throw new IllegalArgumentException("The $JBOSS_HOME/modules director [" + this.modulesDir.getAbsolutePath() + "] must exist to be able to create a new module.");
        }
        String moduleName = addModuleRequest.getModuleName();
        Objects.requireNonNull(moduleName, AddModuleRequest.class.getName() + ".moduleName cannot be null");
        File moduleDir = this.getModulePath(moduleName, addModuleRequest.getSlot());
        if (moduleDir.exists()) {
            throw new IllegalArgumentException("[" + moduleName + "] already exists at [" + moduleDir.getAbsolutePath() + "]");
        }
    }

    void writeModuleXml(Writer out, AddModuleRequest addModuleRequest) throws XMLStreamException {
        Set<String> dependencies;
        Set<AddModuleRequest.ModuleResource> resources;
        String mainClass;
        Map<String, String> properties;
        PrettyWriter writer = new PrettyWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(out));
        writer.writeStartDocument();
        writer.writeStartElement(Name.module.toString());
        writer.writeDefaultNamespace(Name.module_ns.toString());
        writer.writeAttribute(Name.name.toString(), addModuleRequest.getModuleName());
        String slot = addModuleRequest.getSlot();
        if (slot != null) {
            writer.writeAttribute(Name.slot.toString(), slot);
        }
        if ((properties = addModuleRequest.getProperties()) != null && !properties.isEmpty()) {
            writer.writeStartElement(Name.properties.toString());
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.writeEmptyElement(Name.property.toString());
                writer.writeAttribute(Name.name.toString(), entry.getKey());
                writer.writeAttribute(Name.value.toString(), entry.getValue());
            }
            writer.writeEndElement();
        }
        if ((mainClass = addModuleRequest.getMainClass()) != null) {
            writer.writeEmptyElement(Name.main_class.toString());
            writer.writeAttribute(Name.value.toString(), mainClass);
        }
        if ((resources = addModuleRequest.getResources()) != null && !resources.isEmpty()) {
            writer.writeStartElement(Name.resources.toString());
            for (AddModuleRequest.ModuleResource resource : resources) {
                writer.writeEmptyElement(Name.resource_root.toString());
                writer.writeAttribute(Name.path.toString(), resource.getFileName());
            }
            writer.writeEndElement();
        }
        if ((dependencies = addModuleRequest.getDependencies()) != null && !dependencies.isEmpty()) {
            writer.writeStartElement(Name.dependencies.toString());
            for (String dep : dependencies) {
                writer.writeEmptyElement(Name.module.toString());
                writer.writeAttribute(Name.name.toString(), dep);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private static class PrettyWriter
    implements XMLStreamWriter {
        private static final int INDENT_SIZE = 2;
        private static final char[] NEW_LINE = new char[]{'\n'};
        private static final char[] SPACE = new char[]{' '};
        private final XMLStreamWriter delegate;
        private int indent = 0;
        private final Stack<Boolean> stack = new Stack();

        public PrettyWriter(XMLStreamWriter delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws XMLStreamException {
            this.delegate.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.delegate.flush();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.delegate.getPrefix(uri);
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.delegate.getProperty(name);
        }

        private void indent() throws XMLStreamException {
            this.delegate.writeCharacters(NEW_LINE, 0, 1);
            for (int i = 0; i < this.indent; ++i) {
                this.delegate.writeCharacters(SPACE, 0, 1);
            }
            this.indent += 2;
            if (!this.stack.empty()) {
                this.stack.set(this.stack.size() - 1, Boolean.TRUE);
            }
            this.stack.push(Boolean.FALSE);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.delegate.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.delegate.setNamespaceContext(context);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.delegate.setPrefix(prefix, uri);
        }

        private void unindent() throws XMLStreamException {
            this.indent -= 2;
            if (this.stack.pop().booleanValue()) {
                this.delegate.writeCharacters(NEW_LINE, 0, 1);
                for (int i = 0; i < this.indent; ++i) {
                    this.delegate.writeCharacters(SPACE, 0, 1);
                }
            }
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.delegate.writeCData(data);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.delegate.writeCharacters(text, start, len);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.delegate.writeCharacters(text);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.delegate.writeComment(data);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.delegate.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.delegate.writeDTD(dtd);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            this.delegate.writeEmptyElement(localName);
            this.unindent();
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            this.delegate.writeEmptyElement(namespaceURI, localName);
            this.unindent();
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
            this.unindent();
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.delegate.writeEndDocument();
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.unindent();
            this.delegate.writeEndElement();
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.delegate.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.delegate.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.delegate.writeStartDocument();
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.delegate.writeStartDocument(version);
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.delegate.writeStartDocument(encoding, version);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            this.delegate.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            this.delegate.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            this.delegate.writeStartElement(prefix, localName, namespaceURI);
        }
    }

    public static enum Name {
        dependencies,
        main_class{

            public String toString() {
                return "main-class";
            }
        }
        ,
        module,
        module_ns{

            public String toString() {
                return "urn:jboss:module:1.1";
            }
        }
        ,
        name,
        path,
        properties,
        property,
        resource_root{

            public String toString() {
                return "resource-root";
            }
        }
        ,
        resources,
        slot,
        value;

    }
}

