/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;

public class TypeSets<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(TypeSets.class);
    private static final TypeSets<?> EMPTY = new TypeSets(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
    private final Map<Name, TypeSet<AvailType<L>>> availTypeSets;
    private final boolean enabled;
    private final Map<Name, TypeSet<MetricType<L>>> metricTypeSets;
    private final Map<Name, TypeSet<ResourceType<L>>> resourceTypeSets;

    public static <L> Builder<L> builder() {
        return new Builder();
    }

    public static <L> TypeSets<L> empty() {
        return EMPTY;
    }

    private TypeSets(Map<Name, TypeSet<ResourceType<L>>> resourceTypeSets, Map<Name, TypeSet<MetricType<L>>> metricTypeSets, Map<Name, TypeSet<AvailType<L>>> availTypeSets, boolean enabled) {
        this.resourceTypeSets = resourceTypeSets;
        this.metricTypeSets = metricTypeSets;
        this.availTypeSets = availTypeSets;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<Name, TypeSet<AvailType<L>>> getAvailTypeSets() {
        return this.availTypeSets;
    }

    public Map<Name, TypeSet<MetricType<L>>> getMetricTypeSets() {
        return this.metricTypeSets;
    }

    public Map<Name, TypeSet<ResourceType<L>>> getResourceTypeSets() {
        return this.resourceTypeSets;
    }

    public boolean isDisabledOrEmpty() {
        return !this.enabled || this.resourceTypeSets.isEmpty() && this.metricTypeSets.isEmpty() && this.availTypeSets.isEmpty();
    }

    public static class Builder<L> {
        private Map<Name, TypeSet<AvailType<L>>> availTypeSets = new LinkedHashMap<Name, TypeSet<AvailType<L>>>();
        private boolean enabled = true;
        private Map<Name, TypeSet<MetricType<L>>> metricTypeSets = new LinkedHashMap<Name, TypeSet<MetricType<L>>>();
        private Map<Name, TypeSet<ResourceType<L>>> resourceTypeSets = new LinkedHashMap<Name, TypeSet<ResourceType<L>>>();

        public TypeSets<L> build() {
            for (TypeSet<ResourceType<L>> resourceTypeSet : this.resourceTypeSets.values()) {
                for (ResourceType<L> type : resourceTypeSet.getTypeMap().values()) {
                    for (Name metricSetName : type.getMetricSets()) {
                        if (this.metricTypeSets.containsKey(metricSetName)) continue;
                        log.warnMetricSetDoesNotExist(type.getName().toString(), metricSetName.toString());
                    }
                    for (Name availSetName : type.getAvailSets()) {
                        if (this.availTypeSets.containsKey(availSetName)) continue;
                        log.warnAvailSetDoesNotExist(type.getName().toString(), availSetName.toString());
                    }
                }
            }
            return new TypeSets(Collections.unmodifiableMap(this.resourceTypeSets), Collections.unmodifiableMap(this.metricTypeSets), Collections.unmodifiableMap(this.availTypeSets), this.enabled);
        }

        public Builder<L> enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder<L> availTypeSet(TypeSet<AvailType<L>> typeSet) {
            this.availTypeSets.put(typeSet.getName(), typeSet);
            return this;
        }

        public Builder<L> metricTypeSet(TypeSet<MetricType<L>> typeSet) {
            this.metricTypeSets.put(typeSet.getName(), typeSet);
            return this;
        }

        public Builder<L> resourceTypeSet(TypeSet<ResourceType<L>> typeSet) {
            this.resourceTypeSets.put(typeSet.getName(), typeSet);
            return this;
        }

        public Map<Name, TypeSet<AvailType<L>>> getAvailTypeSets() {
            return Collections.unmodifiableMap(this.availTypeSets);
        }

        public Map<Name, TypeSet<MetricType<L>>> getMetricTypeSets() {
            return Collections.unmodifiableMap(this.metricTypeSets);
        }
    }
}

