/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEncryptAction
extends AbstractConditionalProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractEncryptAction.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionCtxLookupStrategy = Functions.compose((Function)new ChildContextLookup(EncryptionContext.class), (Function)new OutboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Encrypter.KeyPlacement> keyPlacementLookupStrategy = FunctionSupport.constant((Object)Encrypter.KeyPlacement.INLINE);
    @Nullable
    private Encrypter encrypter;

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setRecipientLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Recipient lookup strategy cannot be null");
    }

    public void setKeyPlacementLookupStrategy(@Nonnull Function<ProfileRequestContext, Encrypter.KeyPlacement> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyPlacementLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Key placement lookup strategy cannot be null");
    }

    @Nullable
    public Encrypter getEncrypter() {
        return this.encrypter;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EncryptionParameters params = this.getApplicableParameters((EncryptionContext)this.encryptionCtxLookupStrategy.apply((Object)profileRequestContext));
        if (params == null) {
            this.log.debug("{} No encryption parameters, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        String recipient = this.recipientLookupStrategy != null ? (String)this.recipientLookupStrategy.apply((Object)profileRequestContext) : null;
        DataEncryptionParameters dataParams = new DataEncryptionParameters(params);
        KeyEncryptionParameters keyParams = new KeyEncryptionParameters(params, recipient);
        this.encrypter = new Encrypter(dataParams, keyParams);
        this.encrypter.setKeyPlacement((Encrypter.KeyPlacement)this.keyPlacementLookupStrategy.apply((Object)profileRequestContext));
        return super.doPreExecute(profileRequestContext);
    }

    @Nullable
    protected abstract EncryptionParameters getApplicableParameters(@Nullable EncryptionContext var1);
}

