/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class SerialSubscription
implements Subscription {
    volatile State state = new State(false, Subscriptions.empty());
    static final AtomicReferenceFieldUpdater<SerialSubscription, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SerialSubscription.class, State.class, "state");

    @Override
    public boolean isUnsubscribed() {
        return this.state.isUnsubscribed;
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state;
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState = oldState.unsubscribe()));
        oldState.subscription.unsubscribe();
    }

    public void set(Subscription s) {
        State newState;
        State oldState;
        if (s == null) {
            throw new IllegalArgumentException("Subscription can not be null");
        }
        do {
            oldState = this.state;
            if (!oldState.isUnsubscribed) continue;
            s.unsubscribe();
            return;
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState = oldState.set(s)));
        oldState.subscription.unsubscribe();
    }

    public Subscription get() {
        return this.state.subscription;
    }

    private static final class State {
        final boolean isUnsubscribed;
        final Subscription subscription;

        State(boolean u, Subscription s) {
            this.isUnsubscribed = u;
            this.subscription = s;
        }

        State unsubscribe() {
            return new State(true, this.subscription);
        }

        State set(Subscription s) {
            return new State(this.isUnsubscribed, s);
        }
    }
}

