/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;

public interface InventoryBackend<E>
extends AutoCloseable {
    public boolean isPreferringBigTransactions();

    public boolean isUniqueIndexSupported();

    public InventoryBackend<E> startTransaction();

    public E find(CanonicalPath var1) throws ElementNotFoundException;

    public Page<E> query(Query var1, Pager var2);

    public E querySingle(Query var1);

    public Page<E> traverse(E var1, Query var2, Pager var3);

    public E traverseToSingle(E var1, Query var2);

    public <T> Page<T> query(Query var1, Pager var2, Function<E, T> var3, Function<T, Boolean> var4);

    public Iterator<E> getTransitiveClosureOver(E var1, Relationships.Direction var2, String ... var3);

    public boolean hasRelationship(E var1, Relationships.Direction var2, String var3);

    public boolean hasRelationship(E var1, E var2, String var3);

    public Set<E> getRelationships(E var1, Relationships.Direction var2, String ... var3);

    public E getRelationship(E var1, E var2, String var3) throws ElementNotFoundException;

    public E getRelationshipSource(E var1);

    public E getRelationshipTarget(E var1);

    public String extractRelationshipName(E var1);

    public String extractId(E var1);

    public Class<?> extractType(E var1);

    public CanonicalPath extractCanonicalPath(E var1);

    public String extractIdentityHash(E var1);

    public String extractContentHash(E var1);

    public String extractSyncHash(E var1);

    public <T> T convert(E var1, Class<T> var2);

    public E descendToData(E var1, RelativePath var2);

    public E relate(E var1, E var2, String var3, Map<String, Object> var4);

    public E persist(CanonicalPath var1, Blueprint var2);

    public E persist(StructuredData var1);

    public void update(E var1, AbstractElement.Update var2);

    public void updateHashes(E var1, Hashes var2);

    public void delete(E var1);

    public void deleteStructuredData(E var1);

    public void commit() throws CommitFailureException;

    public void rollback();

    public boolean isBackendInternal(E var1);

    public InputStream getGraphSON(String var1);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath var1, Relationships.Direction var2, Class<T> var3, String ... var4);

    default public boolean requiresRollbackAfterFailure(Throwable t) {
        return true;
    }
}

