/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.extension.DMRAvailAttributes;
import org.hawkular.agent.monitor.extension.DMRAvailSetAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricSetAttributes;
import org.hawkular.agent.monitor.extension.DMROperationAttributes;
import org.hawkular.agent.monitor.extension.DMROperationParamAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceConfigAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeSetAttributes;
import org.hawkular.agent.monitor.extension.DiagnosticsAttributes;
import org.hawkular.agent.monitor.extension.FileStoresAttributes;
import org.hawkular.agent.monitor.extension.LocalDMRAttributes;
import org.hawkular.agent.monitor.extension.MemoryAttributes;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.PlatformAttributes;
import org.hawkular.agent.monitor.extension.PowerSourcesAttributes;
import org.hawkular.agent.monitor.extension.ProcessorsAttributes;
import org.hawkular.agent.monitor.extension.RemoteDMRAttributes;
import org.hawkular.agent.monitor.extension.StorageAttributes;
import org.hawkular.agent.monitor.extension.SubsystemAttributes;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MonitorServiceConfigurationBuilder {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorServiceConfigurationBuilder.class);
    private MonitorServiceConfiguration.ProtocolConfiguration.Builder<DMRNodeLocation> dmrConfigBuilder;
    private MonitorServiceConfiguration.ProtocolConfiguration.Builder<PlatformNodeLocation> platformConfigBuilder;
    private MonitorServiceConfiguration.DiagnosticsConfiguration diagnostics;
    private MonitorServiceConfiguration.StorageAdapterConfiguration storageAdapter;
    private MonitorServiceConfiguration.GlobalConfiguration globalConfiguration;

    public MonitorServiceConfigurationBuilder(ModelNode config, OperationContext context) throws OperationFailedException {
        this.globalConfiguration = MonitorServiceConfigurationBuilder.determineGlobalConfig(config, context);
        this.storageAdapter = MonitorServiceConfigurationBuilder.determineStorageAdapterConfig(config, context);
        this.diagnostics = MonitorServiceConfigurationBuilder.determineDiagnosticsConfig(config, context);
        this.dmrConfigBuilder = MonitorServiceConfiguration.ProtocolConfiguration.builder();
        this.platformConfigBuilder = MonitorServiceConfiguration.ProtocolConfiguration.builder();
        TypeSets.Builder<DMRNodeLocation> dmrTypeSetsBuilder = TypeSets.builder();
        MonitorServiceConfigurationBuilder.determineMetricSetDmr(config, context, dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineAvailSetDmr(config, context, dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineResourceTypeSetDmr(config, context, dmrTypeSetsBuilder);
        this.dmrConfigBuilder.typeSets(dmrTypeSetsBuilder.build());
        TypeSets<PlatformNodeLocation> platformTypeSets = MonitorServiceConfigurationBuilder.buildPlatformTypeSets(config, context);
        this.platformConfigBuilder.typeSets(platformTypeSets);
        if (!platformTypeSets.isDisabledOrEmpty()) {
            String machineId = MonitorServiceConfigurationBuilder.determinePlatformMachineId(config, context);
            MonitorServiceConfiguration.EndpointConfiguration endpoint = new MonitorServiceConfiguration.EndpointConfiguration("platform", true, null, null, null, Avail.DOWN, null, null, null, Collections.singletonMap("Machine Id", machineId));
            this.platformConfigBuilder.endpoint(endpoint);
        }
        this.determineManagedServers(config, context);
    }

    public MonitorServiceConfiguration build() {
        return new MonitorServiceConfiguration(this.globalConfiguration, this.diagnostics, this.storageAdapter, this.dmrConfigBuilder.build(), this.platformConfigBuilder.build());
    }

    private static void determineMetricSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("metric-set-dmr")) {
            List metricSetsList = config.get("metric-set-dmr").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                TypeSet.TypeSetBuilder<MetricType<DMRNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(metricSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, DMRMetricSetAttributes.ENABLED));
                if (metricSetValueNode.hasDefined("metric-dmr")) {
                    List metricsList = metricSetValueNode.get("metric-dmr").asPropertyList();
                    for (Property metricProperty : metricsList) {
                        String metricId = metricSetName + "~" + metricProperty.getName();
                        String metricName = metricProperty.getName();
                        ModelNode metricValueNode = metricProperty.getValue();
                        String attributeString = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, DMRMetricAttributes.ATTRIBUTE);
                        PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(metricValueNode, context, DMRMetricAttributes.PATH);
                        boolean re = MonitorServiceConfigurationBuilder.getBoolean(metricValueNode, context, DMRMetricAttributes.RESOLVE_EXPRESSIONS);
                        boolean id = MonitorServiceConfigurationBuilder.getBoolean(metricValueNode, context, DMRMetricAttributes.INCLUDE_DEFAULTS);
                        String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, DMRMetricAttributes.METRIC_ID_TEMPLATE);
                        Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(metricValueNode, context, DMRMetricAttributes.METRIC_TAGS);
                        AttributeLocation<DMRNodeLocation> location = new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(pathAddress, re, id), attributeString);
                        MetricType<DMRNodeLocation> metric = new MetricType<DMRNodeLocation>(new ID(metricId), new Name(metricName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(metricValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(metricValueNode, context, DMRMetricAttributes.TIME_UNITS)), MonitorServiceConfigurationBuilder.getMeasurementUnit(metricValueNode, context, DMRMetricAttributes.METRIC_UNITS), MonitorServiceConfigurationBuilder.getMetricType(metricValueNode, context, DMRMetricAttributes.METRIC_TYPE), metricIdTemplate, metricTags);
                        typeSetBuilder.type(metric);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.metricTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("DMR");
        }
    }

    private static org.hawkular.metrics.client.common.MetricType getMetricType(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricType) throws OperationFailedException {
        String metricTypeStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricType);
        if (metricTypeStr == null) {
            return org.hawkular.metrics.client.common.MetricType.GAUGE;
        }
        return org.hawkular.metrics.client.common.MetricType.valueOf((String)metricTypeStr.toUpperCase(Locale.ENGLISH));
    }

    private static MeasurementUnit getMeasurementUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricUnits) throws OperationFailedException {
        String metricUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricUnits);
        if (metricUnitsStr == null) {
            return MeasurementUnit.NONE;
        }
        return MeasurementUnit.valueOf((String)metricUnitsStr.toUpperCase(Locale.ENGLISH));
    }

    private static TimeUnit getTimeUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition timeUnits) throws OperationFailedException {
        String metricTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, timeUnits);
        return TimeUnit.valueOf(metricTimeUnitsStr.toUpperCase());
    }

    private static void determineAvailSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("avail-set-dmr")) {
            List availSetsList = config.get("avail-set-dmr").asPropertyList();
            for (Property availSetProperty : availSetsList) {
                String availSetName = availSetProperty.getName();
                if (availSetName.indexOf(44) > -1) {
                    log.warnCommaInName(availSetName);
                }
                ModelNode availSetValueNode = availSetProperty.getValue();
                TypeSet.TypeSetBuilder<AvailType<DMRNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(availSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(availSetValueNode, context, DMRAvailSetAttributes.ENABLED));
                if (!availSetValueNode.hasDefined("avail-dmr")) continue;
                List availsList = availSetValueNode.get("avail-dmr").asPropertyList();
                for (Property availProperty : availsList) {
                    String availId = availSetName + "~" + availProperty.getName();
                    String availName = availProperty.getName();
                    ModelNode availValueNode = availProperty.getValue();
                    String attributeString = MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.ATTRIBUTE);
                    PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(availValueNode, context, DMRAvailAttributes.PATH);
                    boolean re = MonitorServiceConfigurationBuilder.getBoolean(availValueNode, context, DMRAvailAttributes.RESOLVE_EXPRESSIONS);
                    boolean id = MonitorServiceConfigurationBuilder.getBoolean(availValueNode, context, DMRAvailAttributes.INCLUDE_DEFAULTS);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(availValueNode, context, DMRAvailAttributes.METRIC_TAGS);
                    AttributeLocation<DMRNodeLocation> location = new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(pathAddress, re, id), attributeString);
                    AvailType<DMRNodeLocation> avail = new AvailType<DMRNodeLocation>(new ID(availId), new Name(availName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(availValueNode, context, DMRAvailAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(availValueNode, context, DMRAvailAttributes.TIME_UNITS)), Pattern.compile(MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.UP_REGEX)), metricIdTemplate, metricTags);
                    typeSetBuilder.type(avail);
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.availTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledAvailsConfigured("DMR");
        }
    }

    private static String determinePlatformMachineId(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("platform")) {
            return null;
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            return null;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        String machineId = MonitorServiceConfigurationBuilder.getString(platformValueNode, context, PlatformAttributes.MACHINE_ID);
        return machineId;
    }

    private static TypeSets<PlatformNodeLocation> buildPlatformTypeSets(ModelNode config, OperationContext context) throws OperationFailedException {
        TypeSet typeSet;
        Interval interval;
        boolean enabled;
        if (!config.hasDefined("platform")) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        boolean typeSetsEnabled = MonitorServiceConfigurationBuilder.getBoolean(platformValueNode, context, PlatformAttributes.ENABLED);
        if (!typeSetsEnabled) {
            log.debugf("Platform monitoring is disabled", new Object[0]);
            return TypeSets.empty();
        }
        TypeSets.Builder typeSetsBuilder = TypeSets.builder();
        ID osId = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeId();
        Name osName = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName();
        Object rootTypeBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(osId)).name(osName)).location(new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.OPERATING_SYSTEM).build()))).resourceNameTemplate("%s");
        ResourceConfigurationPropertyType<PlatformNodeLocation> machineIdConfigType = new ResourceConfigurationPropertyType<PlatformNodeLocation>(ID.NULL_ID, new Name("Machine Id"), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), "Machine Id"));
        ((ResourceType.Builder)rootTypeBldr).resourceConfigurationPropertyType(machineIdConfigType);
        Interval osInterval = new Interval(MonitorServiceConfigurationBuilder.getInt(platformValueNode, context, PlatformAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(platformValueNode, context, PlatformAttributes.TIME_UNITS).toUpperCase()));
        MetricType<PlatformNodeLocation> systemCpuLoad = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType<PlatformNodeLocation> systemLoadAverage = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType<PlatformNodeLocation> processCount = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId(), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        TypeSet osMetrics = TypeSet.builder().name(Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName()).type(systemCpuLoad).type(systemLoadAverage).type(processCount).build();
        typeSetsBuilder.metricTypeSet(osMetrics);
        ((ResourceType.Builder)rootTypeBldr).metricSetName(osMetrics.getName());
        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(rootTypeBldr, typeSetsBuilder);
        ResourceType rootType = ((ResourceType.Builder)rootTypeBldr).build();
        TypeSet rootTypeSet = TypeSet.builder().enabled(true).name(osName).type(rootType).build();
        typeSetsBuilder.resourceTypeSet(rootTypeSet);
        if (platformValueNode.hasDefined("file-stores")) {
            asPropertyList = platformValueNode.get("file-stores").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode fileStoresNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(fileStoresNode, context, FileStoresAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(fileStoresNode, context, FileStoresAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(fileStoresNode, context, FileStoresAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> usableSpace = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType<PlatformNodeLocation> totalSpace = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet fileStoreMetrics = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type(usableSpace).type(totalSpace).build();
                    typeSetsBuilder.metricTypeSet(fileStoreMetrics);
                    PlatformNodeLocation fileStoreLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.FILE_STORE).build());
                    Object fileStoreBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.FILE_STORE.getResourceTypeId())).name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName())).location(fileStoreLocation)).resourceNameTemplate(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName().getNameString() + " [%s]")).parent(rootType.getName())).metricSetName(fileStoreMetrics.getName());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(fileStoreBldr, typeSetsBuilder);
                    ResourceType fileStore = ((ResourceType.Builder)fileStoreBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type(fileStore).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.file-stores config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("memory")) {
            asPropertyList = platformValueNode.get("memory").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode memoryNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(memoryNode, context, MemoryAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(memoryNode, context, MemoryAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(memoryNode, context, MemoryAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> available = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType<PlatformNodeLocation> total = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet memoryMetrics = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type(available).type(total).build();
                    typeSetsBuilder.metricTypeSet(memoryMetrics);
                    PlatformNodeLocation memoryLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.MEMORY).build());
                    Object memoryBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.MEMORY.getResourceTypeId())).name(Constants.PlatformResourceType.MEMORY.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)memoryLocation)).metricSetName(memoryMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.MEMORY.getResourceTypeName().getNameString());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(memoryBldr, typeSetsBuilder);
                    ResourceType memory = ((ResourceType.Builder)memoryBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type(memory).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.memory config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("processors")) {
            asPropertyList = platformValueNode.get("processors").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode processorsNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(processorsNode, context, ProcessorsAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(processorsNode, context, ProcessorsAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(processorsNode, context, ProcessorsAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> cpuUsage = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId(), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet processorMetrics = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type(cpuUsage).build();
                    typeSetsBuilder.metricTypeSet(processorMetrics);
                    PlatformNodeLocation processorsLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.PROCESSOR).build());
                    Object processorBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.PROCESSOR.getResourceTypeId())).name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)processorsLocation)).metricSetName(processorMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(processorBldr, typeSetsBuilder);
                    ResourceType processor = ((ResourceType.Builder)processorBldr).build();
                    TypeSet typeSet2 = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type(processor).build();
                    typeSetsBuilder.resourceTypeSet(typeSet2);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.processors config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("power-sources")) {
            asPropertyList = platformValueNode.get("power-sources").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode powerSourcesNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(powerSourcesNode, context, PowerSourcesAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(powerSourcesNode, context, PowerSourcesAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(powerSourcesNode, context, PowerSourcesAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> remainingCap = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType<PlatformNodeLocation> timeRemaining = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId().getIDString()), interval, MeasurementUnit.SECONDS, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet powerSourceMetrics = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type(remainingCap).type(timeRemaining).build();
                    typeSetsBuilder.metricTypeSet(powerSourceMetrics);
                    PlatformNodeLocation powerSourcesLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.POWER_SOURCE).build());
                    Object powerSourceBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeId())).name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)powerSourcesLocation)).metricSetName(powerSourceMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(powerSourceBldr, typeSetsBuilder);
                    ResourceType powerSource = ((ResourceType.Builder)powerSourceBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type(powerSource).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.power-sources config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        return typeSetsBuilder.build();
    }

    private static MonitorServiceConfiguration.DiagnosticsConfiguration determineDiagnosticsConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("diagnostics")) {
            log.infoNoDiagnosticsConfig();
            return MonitorServiceConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        List asPropertyList = config.get("diagnostics").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoDiagnosticsConfig();
            return MonitorServiceConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one diagnostics config allowed: " + config.toJSONString(true));
        }
        ModelNode diagnosticsValueNode = ((Property)asPropertyList.get(0)).getValue();
        String reportToStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.REPORT_TO);
        MonitorServiceConfiguration.DiagnosticsReportTo reportTo = MonitorServiceConfiguration.DiagnosticsReportTo.valueOf(reportToStr.toUpperCase());
        boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(diagnosticsValueNode, context, DiagnosticsAttributes.ENABLED);
        int interval = MonitorServiceConfigurationBuilder.getInt(diagnosticsValueNode, context, DiagnosticsAttributes.INTERVAL);
        String diagnosticsTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.TIME_UNITS);
        TimeUnit timeUnits = TimeUnit.valueOf(diagnosticsTimeUnitsStr.toUpperCase());
        return new MonitorServiceConfiguration.DiagnosticsConfiguration(enabled, reportTo, interval, timeUnits);
    }

    private static MonitorServiceConfiguration.StorageAdapterConfiguration determineStorageAdapterConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("storage-adapter")) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        List asPropertyList = config.get("storage-adapter").asPropertyList();
        if (asPropertyList.size() == 0) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one storage adapter allowed: " + config.toJSONString(true));
        }
        ModelNode storageAdapterConfig = ((Property)asPropertyList.get(0)).getValue();
        String url = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.URL);
        boolean useSSL = false;
        if (url != null) {
            useSSL = url.startsWith("https");
            log.infoUsingSSL(url, useSSL);
        } else {
            useSSL = MonitorServiceConfigurationBuilder.getBoolean(storageAdapterConfig, context, StorageAttributes.USE_SSL);
        }
        String securityRealm = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SECURITY_REALM);
        String keystorePath = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PATH);
        String keystorePassword = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PASSWORD);
        String serverOutboundSocketBindingRef = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SERVER_OUTBOUND_SOCKET_BINDING_REF);
        String tenantId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TENANT_ID);
        String feedId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEED_ID);
        String inventoryContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.INVENTORY_CONTEXT);
        String metricsContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.METRICS_CONTEXT);
        String feedcommContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEEDCOMM_CONTEXT);
        String username = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.USERNAME);
        String password = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.PASSWORD);
        String typeStr = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TYPE);
        MonitorServiceConfiguration.StorageReportTo type = MonitorServiceConfiguration.StorageReportTo.valueOf(typeStr.toUpperCase());
        int connectTimeoutSeconds = MonitorServiceConfigurationBuilder.getInt(storageAdapterConfig, context, StorageAttributes.CONNECT_TIMEOUT_SECONDS);
        int readTimeoutSeconds = MonitorServiceConfigurationBuilder.getInt(storageAdapterConfig, context, StorageAttributes.READ_TIMEOUT_SECONDS);
        if (useSSL && securityRealm == null) {
            if (keystorePath == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePath must be specified");
            }
            if (keystorePassword == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePassword must be specified");
            }
        }
        if (username == null || password == null) {
            throw new IllegalArgumentException("Must have a username/password");
        }
        return new MonitorServiceConfiguration.StorageAdapterConfiguration(type, username, password, tenantId, feedId, url, useSSL, serverOutboundSocketBindingRef, inventoryContext, metricsContext, feedcommContext, keystorePath, keystorePassword, securityRealm, connectTimeoutSeconds, readTimeoutSeconds);
    }

    private static MonitorServiceConfiguration.GlobalConfiguration determineGlobalConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        boolean subsystemEnabled = MonitorServiceConfigurationBuilder.getBoolean(config, context, SubsystemAttributes.ENABLED);
        String apiJndi = MonitorServiceConfigurationBuilder.getString(config, context, SubsystemAttributes.API_JNDI);
        int autoDiscoveryScanPeriodSecs = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AUTO_DISCOVERY_SCAN_PERIOD_SECONDS);
        int numDmrSchedulerThreads = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.NUM_DMR_SCHEDULER_THREADS);
        int metricDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_BUFFER_SIZE);
        int metricDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_MAX_BATCH_SIZE);
        int availDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_BUFFER_SIZE);
        int availDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_MAX_BATCH_SIZE);
        int pingDispatcherPeriodSeconds = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.PING_DISPATCHER_PERIOD_SECONDS);
        return new MonitorServiceConfiguration.GlobalConfiguration(subsystemEnabled, apiJndi, autoDiscoveryScanPeriodSecs, numDmrSchedulerThreads, metricDispatcherBufferSize, metricDispatcherMaxBatchSize, availDispatcherBufferSize, availDispatcherMaxBatchSize, pingDispatcherPeriodSeconds);
    }

    private static void determineResourceTypeSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("resource-type-set-dmr")) {
            List resourceTypeSetsList = config.get("resource-type-set-dmr").asPropertyList();
            for (Property resourceTypeSetProperty : resourceTypeSetsList) {
                String resourceTypeSetName = resourceTypeSetProperty.getName();
                ModelNode resourceTypeSetValueNode = resourceTypeSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(resourceTypeSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(resourceTypeSetValueNode, context, DMRResourceTypeSetAttributes.ENABLED));
                if (resourceTypeSetName.indexOf(44) > -1) {
                    log.warnCommaInName(resourceTypeSetName);
                }
                if (resourceTypeSetValueNode.hasDefined("resource-type-dmr")) {
                    List resourceTypesList = resourceTypeSetValueNode.get("resource-type-dmr").asPropertyList();
                    for (Property resourceTypeProperty : resourceTypesList) {
                        ModelNode configModelNode;
                        ModelNode resourceTypeValueNode = resourceTypeProperty.getValue();
                        String resourceTypeName = resourceTypeProperty.getName();
                        Object resourceTypeBuilder = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(ID.NULL_ID)).name(new Name(resourceTypeName))).location(new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(resourceTypeValueNode, context, DMRResourceTypeAttributes.PATH)))).resourceNameTemplate(MonitorServiceConfigurationBuilder.getString(resourceTypeValueNode, context, DMRResourceTypeAttributes.RESOURCE_NAME_TEMPLATE))).parents(MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.PARENTS));
                        List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.METRIC_SETS);
                        List<Name> availSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.AVAIL_SETS);
                        ((ResourceType.Builder)((ResourceType.Builder)resourceTypeBuilder).metricSetNames(metricSets)).availSetNames(availSets);
                        ModelNode opModelNode = resourceTypeValueNode.get("operation-dmr");
                        if (opModelNode != null && opModelNode.isDefined()) {
                            List operationList = opModelNode.asPropertyList();
                            for (Property operationProperty : operationList) {
                                ModelNode operationValueNode = operationProperty.getValue();
                                String name = operationProperty.getName();
                                List<OperationParam> params = MonitorServiceConfigurationBuilder.getOpParamListFromOpNode(operationValueNode, context);
                                PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(operationValueNode, context, DMROperationAttributes.PATH);
                                String internalName = MonitorServiceConfigurationBuilder.getString(operationValueNode, context, DMROperationAttributes.INTERNAL_NAME);
                                Operation<DMRNodeLocation> op = new Operation<DMRNodeLocation>(ID.NULL_ID, new Name(name), new DMRNodeLocation(pathAddress), internalName, params);
                                ((ResourceType.Builder)resourceTypeBuilder).operation(op);
                            }
                        }
                        if ((configModelNode = resourceTypeValueNode.get("resource-config-dmr")) != null && configModelNode.isDefined()) {
                            List configList = configModelNode.asPropertyList();
                            for (Property configProperty : configList) {
                                ModelNode configValueNode = configProperty.getValue();
                                String configName = configProperty.getName();
                                String attributeString = MonitorServiceConfigurationBuilder.getString(configValueNode, context, DMRResourceConfigAttributes.ATTRIBUTE);
                                PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(configValueNode, context, DMRResourceConfigAttributes.PATH);
                                boolean re = MonitorServiceConfigurationBuilder.getBoolean(configValueNode, context, DMRResourceConfigAttributes.RESOLVE_EXPRESSIONS);
                                boolean id = MonitorServiceConfigurationBuilder.getBoolean(configValueNode, context, DMRResourceConfigAttributes.INCLUDE_DEFAULTS);
                                ResourceConfigurationPropertyType<DMRNodeLocation> configType = new ResourceConfigurationPropertyType<DMRNodeLocation>(ID.NULL_ID, new Name(configName), new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(pathAddress, re, id), attributeString));
                                ((ResourceType.Builder)resourceTypeBuilder).resourceConfigurationPropertyType(configType);
                            }
                        }
                        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(resourceTypeBuilder, typeSetsBuilder);
                        ResourceType resourceType = ((ResourceType.Builder)resourceTypeBuilder).build();
                        typeSetBuilder.type(resourceType);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.resourceTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledResourceTypesConfigured("DMR");
        }
    }

    private void determineManagedServers(ModelNode config, OperationContext context) throws OperationFailedException {
        if (config.hasDefined("managed-servers")) {
            List asPropertyList = config.get("managed-servers").asPropertyList();
            if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Can only have one <managed-resources>: " + config.toJSONString(true));
            }
            ModelNode managedServersValueNode = ((Property)asPropertyList.get(0)).getValue();
            if (managedServersValueNode.hasDefined("remote-dmr")) {
                List remoteDMRsList = managedServersValueNode.get("remote-dmr").asPropertyList();
                for (Property remoteDMRProperty : remoteDMRsList) {
                    String name = remoteDMRProperty.getName();
                    ModelNode remoteDMRValueNode = remoteDMRProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.ENABLED);
                    String setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                    Avail setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf(setAvailOnShutdownStr);
                    String host = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.HOST);
                    int port = MonitorServiceConfigurationBuilder.getInt(remoteDMRValueNode, context, RemoteDMRAttributes.PORT);
                    String username = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.PASSWORD);
                    boolean useSsl = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.USE_SSL);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SECURITY_REALM);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(remoteDMRValueNode, context, RemoteDMRAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.TENANT_ID);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(remoteDMRValueNode, context, RemoteDMRAttributes.METRIC_TAGS);
                    if (useSsl && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    String protocol = useSsl ? "https-remoting" : "http-remoting";
                    ConnectionData connectionData = new ConnectionData(protocol, host, port, username, password);
                    MonitorServiceConfiguration.EndpointConfiguration endpoint = new MonitorServiceConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, connectionData, securityRealm, setAvailOnShutdown, tenantId, metricIdTemplate, metricTags, null);
                    this.dmrConfigBuilder.endpoint(endpoint);
                }
            }
            if (managedServersValueNode.hasDefined("local-dmr")) {
                List localDMRsList = managedServersValueNode.get("local-dmr").asPropertyList();
                if (localDMRsList.size() > 1) {
                    throw new IllegalArgumentException("Can only have one <local-dmr>: " + config.toJSONString(true));
                }
                Property localDMRProperty = (Property)localDMRsList.get(0);
                String name = localDMRProperty.getName();
                ModelNode localDMRValueNode = localDMRProperty.getValue();
                boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(localDMRValueNode, context, LocalDMRAttributes.ENABLED);
                String setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                Avail setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf(setAvailOnShutdownStr);
                List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(localDMRValueNode, context, LocalDMRAttributes.RESOURCE_TYPE_SETS);
                String tenantId = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.TENANT_ID);
                String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.METRIC_ID_TEMPLATE);
                Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(localDMRValueNode, context, LocalDMRAttributes.METRIC_TAGS);
                MonitorServiceConfiguration.EndpointConfiguration endpoint = new MonitorServiceConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, null, null, setAvailOnShutdown, tenantId, metricIdTemplate, metricTags, null);
                this.dmrConfigBuilder.endpoint(endpoint);
            }
        }
    }

    private static boolean getBoolean(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asBoolean() : false;
    }

    private static String getString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asString() : null;
    }

    private static PathAddress getPath(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String path = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (path == null) {
            return null;
        }
        if ("/".equals(path)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        return PathAddress.parseCLIStyleAddress((String)path);
    }

    private static int getInt(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asInt() : 0;
    }

    private static String getObjectName(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String value = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (value != null && !value.isEmpty()) {
            try {
                new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new OperationFailedException(String.format("Attribute [%s] is an invalid object name [%s]", attrib.getName(), value), (Throwable)e);
            }
        }
        return value;
    }

    private static List<Name> getNameListFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            String commaSeparatedList = value.asString();
            String[] stringArray = commaSeparatedList.split(",");
            ArrayList<Name> names = new ArrayList<Name>(stringArray.length);
            for (String str : stringArray) {
                names.add(new Name(str));
            }
            return names;
        }
        return Collections.emptyList();
    }

    private static List<OperationParam> getOpParamListFromOpNode(ModelNode modelNode, OperationContext context) throws OperationFailedException {
        ArrayList<OperationParam> ret = new ArrayList<OperationParam>();
        ModelNode params = modelNode.get("param");
        if (params == null || !params.isDefined()) {
            return Collections.emptyList();
        }
        List propList = params.asPropertyList();
        for (Property prop : propList) {
            String paramName = prop.getName();
            ModelNode paramModelNode = prop.getValue();
            String paramType = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.TYPE);
            String paramDesc = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.DESCRIPTION);
            String paramDefaultValue = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.DEFAULT_VALUE);
            Boolean paramRequired = MonitorServiceConfigurationBuilder.getBoolean(paramModelNode, context, DMROperationParamAttributes.REQUIRED);
            OperationParam operationParam = new OperationParam(paramName, paramType, paramDesc, paramDefaultValue, paramRequired);
            ret.add(operationParam);
        }
        return ret;
    }

    private static Map<String, String> getMapFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String commaSeparatedList = value.asString();
            StringTokenizer strtok = new StringTokenizer(commaSeparatedList, ",");
            while (strtok.hasMoreTokens()) {
                String nameValueToken = strtok.nextToken().trim();
                String[] nameValueArr = nameValueToken.split("=");
                if (nameValueArr.length != 2) {
                    throw new OperationFailedException("missing '=' in name-value pair: " + commaSeparatedList);
                }
                map.put(nameValueArr[0].trim(), nameValueArr[1].trim());
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static <L> void populateMetricAndAvailTypesForResourceType(ResourceType.Builder<?, L> resourceTypeBuilder, TypeSets.Builder<L> typeSetsBuilder) {
        Map<Name, TypeSet<MetricType<L>>> metricTypeSets = typeSetsBuilder.getMetricTypeSets();
        List<Name> metricSetNames = resourceTypeBuilder.getMetricSetNames();
        for (Name metricSetName : metricSetNames) {
            TypeSet<MetricType<L>> metricSet = metricTypeSets.get(metricSetName);
            if (metricSet == null || !metricSet.isEnabled()) continue;
            resourceTypeBuilder.metricTypes(metricSet.getTypeMap().values());
        }
        Map<Name, TypeSet<AvailType<L>>> availTypeSets = typeSetsBuilder.getAvailTypeSets();
        List<Name> availSetNames = resourceTypeBuilder.getAvailSetNames();
        for (Name availSetName : availSetNames) {
            TypeSet<AvailType<L>> availSet = availTypeSets.get(availSetName);
            if (availSet == null || !availSet.isEnabled()) continue;
            resourceTypeBuilder.availTypes(availSet.getTypeMap().values());
        }
    }
}

