/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.AbstractHandlerDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;

public class ModClusterDefinition
extends AbstractHandlerDefinition {
    public static final AttributeDefinition MANAGEMENT_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-socket-binding", ModelType.STRING).setAllowExpression(true)).setAllowNull(false)).build();
    public static final AttributeDefinition ADVERTISE_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-socket-binding", ModelType.STRING).setAllowExpression(true)).setAllowNull(false)).build();
    public static final AttributeDefinition SECURITY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-key", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).build();
    public static final AttributeDefinition ADVERTISE_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-protocol", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(new ModelNode("http"))).build();
    public static final AttributeDefinition ADVERTISE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-path", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(new ModelNode("/"))).build();
    public static final AttributeDefinition ADVERTISE_FREQUENCY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-frequency", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setDefaultValue(new ModelNode(10000))).build();
    public static final AttributeDefinition HEALTH_CHECK_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("health-check-interval", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setDefaultValue(new ModelNode(10000))).build();
    public static final AttributeDefinition BROKEN_NODE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("broken-node-timeout", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setDefaultValue(new ModelNode(60000))).build();
    public static final AttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(new ModelNode("default"))).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setDefaultValue(new ModelNode(-1))).build();
    public static final AttributeDefinition MANAGEMENT_ACCESS_PREDICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-access-predicate", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).build();
    public static final AttributeDefinition CACHED_CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cached-connections-per-thread", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).build();
    public static final AttributeDefinition CONNECTION_IDLE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-idle-timeout", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(60))).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(1000))).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).build();
    public static final SimpleAttributeDefinition USE_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-alias", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final SimpleAttributeDefinition ENABLE_HTTP2 = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-http2", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(MANAGEMENT_SOCKET_BINDING, ADVERTISE_SOCKET_BINDING, SECURITY_KEY, ADVERTISE_PROTOCOL, ADVERTISE_PATH, ADVERTISE_FREQUENCY, HEALTH_CHECK_INTERVAL, BROKEN_NODE_TIMEOUT, WORKER, MAX_REQUEST_TIME, MANAGEMENT_ACCESS_PREDICATE, CONNECTIONS_PER_THREAD, CACHED_CONNECTIONS_PER_THREAD, CONNECTION_IDLE_TIMEOUT, REQUEST_QUEUE_SIZE, SECURITY_REALM, USE_ALIAS, ENABLE_HTTP2));
    public static final ModClusterDefinition INSTANCE = new ModClusterDefinition();

    private ModClusterDefinition() {
        super("mod-cluster", new ModClusterAdd(), (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(UndertowService.FILTER, (AbstractAddStepHandler)new ModClusterAdd()));
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public Class<? extends HttpHandler> getHandlerClass() {
        return ProxyHandler.class;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        throw new IllegalStateException();
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)ModClusterBalancerDefinition.INSTANCE);
    }

    static class ModClusterAdd
    extends AbstractAddStepHandler {
        ModClusterAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String name = address.getLastElement().getValue();
            ModClusterService.install(name, context.getServiceTarget(), model, context);
        }

        protected Resource createResource(OperationContext context, ModelNode operation) {
            if (context.isDefaultRequiresRuntime()) {
                Resource delegate = Resource.Factory.create();
                ModClusterResource result = new ModClusterResource(delegate, context.getCurrentAddressValue());
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)result);
                return result;
            }
            return super.createResource(context, operation);
        }
    }
}

