/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.concurrent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CopyJob
implements Runnable {
    private final InputStream is;
    private final OutputStream os;
    private volatile boolean terminated;
    private final boolean closeOsOnExit;

    public CopyJob(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    public CopyJob(InputStream is, OutputStream os, boolean closeOutputStreamOnExit) {
        if (is == null || os == null) {
            throw new IllegalArgumentException("Constructor parameters can't be null");
        }
        this.is = is;
        this.os = os;
        this.closeOsOnExit = closeOutputStreamOnExit;
    }

    @Override
    public final void run() {
        try {
            this.copy(this.is, this.os);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
            if (this.closeOsOnExit) {
                try {
                    this.os.flush();
                    this.os.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[512];
        int countOfBytes = -1;
        while (!this.terminated) {
            while (is.available() <= 0) {
                CopyJob copyJob = this;
                synchronized (copyJob) {
                    try {
                        this.wait(50L);
                        if (this.terminated) {
                            return;
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace(System.err);
                    }
                }
            }
            countOfBytes = is.read(buffer, 0, buffer.length);
            os.write(buffer, 0, countOfBytes);
        }
    }

    public final void kill() {
        this.terminated = true;
    }
}

