/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.context.beanstore.LockStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AttributeBeanStore
implements BoundBeanStore {
    private final HashMapBeanStore beanStore;
    private final NamingScheme namingScheme;
    private final boolean attributeLazyFetchingEnabled;
    private boolean attached;

    public AttributeBeanStore(NamingScheme namingScheme, boolean attributeLazyFetchingEnabled) {
        this.namingScheme = namingScheme;
        this.beanStore = new HashMapBeanStore();
        this.attributeLazyFetchingEnabled = attributeLazyFetchingEnabled;
    }

    @Override
    public boolean detach() {
        if (this.attached) {
            this.attached = false;
            ContextLogger.LOG.beanStoreDetached(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean attach() {
        if (!this.attached) {
            this.attached = true;
            if (this.isLocalBeanStoreSyncNeeded()) {
                if (!this.beanStore.delegate().isEmpty()) {
                    for (BeanIdentifier id : this.beanStore) {
                        ContextualInstance instance = this.beanStore.get(id);
                        String prefixedId = this.getNamingScheme().prefix(id);
                        ContextLogger.LOG.updatingStoreWithContextualUnderId(instance, id);
                        this.setAttribute(prefixedId, instance);
                    }
                }
                if (!this.isAttributeLazyFetchingEnabled()) {
                    this.fetchUninitializedAttributes();
                }
            }
            return true;
        }
        return false;
    }

    public void fetchUninitializedAttributes() {
        for (String prefixedId : this.getPrefixedAttributeNames()) {
            BeanIdentifier id = this.getNamingScheme().deprefix(prefixedId);
            if (this.beanStore.contains(id)) continue;
            ContextualInstance instance = (ContextualInstance)this.getAttribute(prefixedId);
            this.beanStore.put(id, instance);
            ContextLogger.LOG.addingDetachedContextualUnderId(instance, id);
        }
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public <T> ContextualInstance<T> get(BeanIdentifier id) {
        ContextualInstance instance = this.beanStore.get(id);
        if (instance == null && this.isAttached() && this.isAttributeLazyFetchingEnabled() && (instance = (ContextualInstance)Reflections.cast(this.getAttribute(this.namingScheme.prefix(id)))) != null) {
            this.beanStore.put(id, instance);
        }
        ContextLogger.LOG.contextualInstanceFound(id, instance, this);
        return instance;
    }

    @Override
    public <T> void put(BeanIdentifier id, ContextualInstance<T> instance) {
        this.beanStore.put(id, instance);
        if (this.isAttached()) {
            this.setAttribute(this.namingScheme.prefix(id), instance);
        }
        ContextLogger.LOG.contextualInstanceAdded(instance.getContextual(), id, this);
    }

    @Override
    public <T> ContextualInstance<T> remove(BeanIdentifier id) {
        ContextualInstance instance = this.beanStore.remove(id);
        if (instance != null) {
            if (this.isAttached()) {
                this.removeAttribute(this.namingScheme.prefix(id));
            }
            ContextLogger.LOG.contextualInstanceRemoved(id, this);
        }
        return instance;
    }

    @Override
    public void clear() {
        Iterator<BeanIdentifier> it = this.iterator();
        while (it.hasNext()) {
            BeanIdentifier id = it.next();
            if (this.isAttached()) {
                String prefixedId = this.namingScheme.prefix(id);
                this.removeAttribute(prefixedId);
            }
            it.remove();
            ContextLogger.LOG.contextualInstanceRemoved(id, this);
        }
        ContextLogger.LOG.contextCleared(this);
    }

    @Override
    public boolean contains(BeanIdentifier id) {
        return this.get(id) != null;
    }

    protected NamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public Iterator<BeanIdentifier> iterator() {
        Iterator<Object> iterator;
        if (this.isAttributeLazyFetchingEnabled()) {
            HashSet<BeanIdentifier> identifiers = new HashSet<BeanIdentifier>();
            for (BeanIdentifier id : this.beanStore) {
                identifiers.add(id);
            }
            for (String prefixedId : this.getPrefixedAttributeNames()) {
                identifiers.add(this.getNamingScheme().deprefix(prefixedId));
            }
            iterator = identifiers.iterator();
        } else {
            iterator = this.beanStore.iterator();
        }
        return iterator;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Iterator<String> getAttributeNames();

    protected Collection<String> getPrefixedAttributeNames() {
        return this.getNamingScheme().filterIds(this.getAttributeNames());
    }

    protected abstract void setAttribute(String var1, Object var2);

    @Override
    public LockedBean lock(BeanIdentifier id) {
        LockStore lockStore = this.getLockStore();
        if (lockStore == null) {
            return null;
        }
        return lockStore.lock(id);
    }

    protected abstract LockStore getLockStore();

    protected boolean isLocalBeanStoreSyncNeeded() {
        return true;
    }

    public boolean isAttributeLazyFetchingEnabled() {
        return this.attributeLazyFetchingEnabled;
    }
}

