/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.CacheSet;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Listeners;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Traversable;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class ReadWriteMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.ReadWriteMap<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteMapImpl.class);
    private final Params params;

    private ReadWriteMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(functionalMap);
        this.params = params;
    }

    public static <K, V> FunctionalMap.ReadWriteMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return new ReadWriteMapImpl<K, V>(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.ReadWriteMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new ReadWriteMapImpl<K, V>(params, functionalMap);
    }

    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        Param futureMode = this.params.get(0);
        ReadWriteKeyCommand cmd = this.fmap.cmdFactory().buildReadWriteKeyCommand(key, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return Params.withFuture(futureMode, this.fmap.asyncExec(), () -> this.fmap.chain().invoke(ctx, cmd));
    }

    public <R> CompletableFuture<R> eval(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", key, value, this.params);
        Param futureMode = this.params.get(0);
        ReadWriteKeyValueCommand cmd = this.fmap.cmdFactory().buildReadWriteKeyValueCommand(key, value, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return Params.withFuture(futureMode, this.fmap.asyncExec(), () -> this.fmap.chain().invoke(ctx, cmd));
    }

    public <R> Traversable<R> evalMany(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", entries, this.params);
        Param futureMode = this.params.get(0);
        ReadWriteManyEntriesCommand<? extends K, ? extends V, R> cmd = this.fmap.cmdFactory().buildReadWriteManyEntriesCommand(entries, f);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, entries.size());
        return Traversables.of(((List)this.fmap.chain().invoke(ctx, cmd)).stream());
    }

    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", keys, this.params);
        Param futureMode = this.params.get(0);
        ReadWriteManyCommand<? extends K, V, R> cmd = this.fmap.cmdFactory().buildReadWriteManyCommand(keys, f);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, keys.size());
        return Traversables.of(((List)this.fmap.chain().invoke(ctx, cmd)).stream());
    }

    public <R> Traversable<R> evalAll(Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalAll(%s)", this.params);
        Param futureMode = this.params.get(0);
        CacheSet keys = this.fmap.cache.keySet();
        ReadWriteManyCommand cmd = this.fmap.cmdFactory().buildReadWriteManyCommand(keys, f);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, keys.size());
        return Traversables.of(((List)this.fmap.chain().invoke(ctx, cmd)).stream());
    }

    public Listeners.ReadWriteListeners<K, V> listeners() {
        return this.fmap.notifier();
    }

    public FunctionalMap.ReadWriteMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return ReadWriteMapImpl.create(this.params.addAll(ps), this.fmap);
    }
}

