/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.BatchSubsystemDefinition;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet.Namespace;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

public class BatchSubsystemWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        List repositories;
        ThreadsParser threadsParser = ThreadsParser.getInstance();
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        BatchSubsystemDefinition.DEFAULT_JOB_REPOSITORY.marshallAsElement(model, (XMLStreamWriter)writer);
        BatchSubsystemDefinition.DEFAULT_THREAD_POOL.marshallAsElement(model, (XMLStreamWriter)writer);
        BatchSubsystemDefinition.RESTART_JOBS_ON_RESUME.marshallAsElement(model, (XMLStreamWriter)writer);
        if (model.hasDefined("in-memory-job-repository")) {
            repositories = model.get("in-memory-job-repository").asPropertyList();
            for (Property property : repositories) {
                writer.writeStartElement(Element.JOB_REPOSITORY.getLocalName());
                BatchSubsystemWriter.writeNameAttribute(writer, property.getName());
                writer.writeEmptyElement(Element.IN_MEMORY.getLocalName());
                writer.writeEndElement();
            }
        }
        if (model.hasDefined("jdbc-job-repository")) {
            repositories = model.get("jdbc-job-repository").asPropertyList();
            for (Property property : repositories) {
                writer.writeStartElement(Element.JOB_REPOSITORY.getLocalName());
                BatchSubsystemWriter.writeNameAttribute(writer, property.getName());
                writer.writeStartElement(Element.JDBC.getLocalName());
                JdbcJobRepositoryDefinition.DATA_SOURCE.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (model.hasDefined("thread-pool")) {
            List threadPools = model.get("thread-pool").asPropertyList();
            for (Property threadPool : threadPools) {
                threadsParser.writeUnboundedQueueThreadPool(writer, threadPool, Element.THREAD_POOL.getLocalName(), true);
            }
        }
        if (model.hasDefined("thread-factory")) {
            List threadFactories = model.get("thread-factory").asPropertyList();
            for (Property threadFactory : threadFactories) {
                threadsParser.writeThreadFactory(writer, threadFactory);
            }
        }
        writer.writeEndElement();
    }

    private static void writeNameAttribute(XMLExtendedStreamWriter writer, String name) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
    }
}

