/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Base64;
import org.jboss.resteasy.util.GenericType;

public class PKCS7SignatureInput<T> {
    private PublicKey publicKey;
    private X509Certificate certificate;
    private Class type;
    private Type genericType;
    private CMSSignedData data;
    private Annotation[] annotations;
    private Providers providers;
    private Object entity;

    public PKCS7SignatureInput() {
    }

    public PKCS7SignatureInput(CMSSignedData data) {
        this.data = data;
    }

    public PKCS7SignatureInput(String base64) {
        try {
            byte[] bytes = Base64.decode((String)base64);
            this.data = new CMSSignedData(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PKCS7SignatureInput(byte[] bytes) {
        try {
            this.data = new CMSSignedData(bytes);
        }
        catch (CMSException e) {
            throw new RuntimeException(e);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setType(GenericType type) {
        this.type = type.getType();
        this.genericType = type.getGenericType();
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public CMSSignedData getData() {
        return this.data;
    }

    public void setData(CMSSignedData data) {
        this.data = data;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public T getEntity(MediaType mediaType) {
        return (T)this.getEntity(this.type, this.genericType, this.annotations, mediaType);
    }

    public <T2> T2 getEntity(Class<T2> type, MediaType mediaType) {
        return this.getEntity(type, type, this.annotations, mediaType);
    }

    public <T2> T2 getEntity(GenericType<T2> gt, MediaType mediaType) {
        return this.getEntity(gt.getType(), gt.getGenericType(), this.annotations, mediaType);
    }

    public <T2> T2 getEntity(GenericType<T2> gt, Annotation[] ann, MediaType mediaType) {
        return this.getEntity(gt.getType(), gt.getGenericType(), ann, mediaType);
    }

    public <T2> T2 getEntity(Class<T2> t, Type gt, Annotation[] ann, MediaType mediaType) {
        if (this.entity != null) {
            return (T2)this.entity;
        }
        byte[] bytes = (byte[])this.data.getSignedContent().getContent();
        MessageBodyReader reader = this.providers.getMessageBodyReader(t, gt, ann, mediaType);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            this.entity = reader.readFrom(t, gt, ann, mediaType, (MultivaluedMap)new MultivaluedMapImpl(), (InputStream)is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T2)this.entity;
    }

    public boolean verify() throws Exception {
        if (this.certificate != null) {
            return this.verify(this.certificate);
        }
        if (this.publicKey != null) {
            return this.verify(this.publicKey);
        }
        throw new NullPointerException(Messages.MESSAGES.certificateNorPublicKeySet());
    }

    public boolean verify(X509Certificate certificate) throws Exception {
        for (Object info : this.data.getSignerInfos().getSigners()) {
            SignerInformation signer = (SignerInformation)info;
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certificate))) continue;
            return true;
        }
        return false;
    }

    public boolean verify(PublicKey publicKey) throws Exception {
        for (Object info : this.data.getSignerInfos().getSigners()) {
            SignerInformation signer = (SignerInformation)info;
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(publicKey))) continue;
            return true;
        }
        return false;
    }
}

