/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.parser;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.ws.common.JavaUtils;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.util.StAXUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WSDeploymentAspectParser {
    private static final String NS = "urn:jboss:ws:deployment:aspects:1.0";
    private static final String DEPLOYMENT_ASPECTS = "deploymentAspects";
    private static final String DEPLOYMENT_ASPECT = "deploymentAspect";
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String MAP = "map";
    private static final String KEY_CLASS = "keyClass";
    private static final String VALUE_CLASS = "valueClass";
    private static final String ENTRY = "entry";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String LIST = "list";
    private static final String ELEMENT_CLASS = "elementClass";

    public static List<DeploymentAspect> parse(InputStream is, ClassLoader loader) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader((InputStream)is);
            return WSDeploymentAspectParser.parse(xmlr, loader);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static List<DeploymentAspect> parse(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        List<DeploymentAspect> deploymentAspects = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECTS)) {
                    deploymentAspects = WSDeploymentAspectParser.parseDeploymentAspects(reader, loader);
                    break;
                }
                throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
            }
        }
        return deploymentAspects;
    }

    private static List<DeploymentAspect> parseDeploymentAspects(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        LinkedList<DeploymentAspect> deploymentAspects = new LinkedList<DeploymentAspect>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECTS)) {
                        return deploymentAspects;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECT)) {
                        deploymentAspects.add(WSDeploymentAspectParser.parseDeploymentAspect(reader, loader));
                        break;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeploymentAspect parseDeploymentAspect(XMLStreamReader reader, ClassLoader loader) throws XMLStreamException {
        String deploymentAspectClass = reader.getAttributeValue(null, CLASS);
        if (deploymentAspectClass == null) {
            throw WSLogger.ROOT_LOGGER.missingDeploymentAspectClassAttribute();
        }
        DeploymentAspect deploymentAspect = null;
        try {
            Class<?> clazz = Class.forName(deploymentAspectClass, true, loader);
            ClassLoader orig = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)loader);
                deploymentAspect = (DeploymentAspect)clazz.newInstance();
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)orig);
            }
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.cannotInstantiateDeploymentAspect(e, deploymentAspectClass);
        }
        String priority = reader.getAttributeValue(null, PRIORITY);
        if (priority != null) {
            deploymentAspect.setRelativeOrder(Integer.parseInt(priority.trim()));
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)DEPLOYMENT_ASPECT)) {
                        return deploymentAspect;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)PROPERTY)) {
                        WSDeploymentAspectParser.parseProperty(reader, deploymentAspect, loader);
                        break;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }

    private static void parseProperty(XMLStreamReader reader, DeploymentAspect deploymentAspect, ClassLoader loader) throws XMLStreamException {
        Class<?> deploymentAspectClass = deploymentAspect.getClass();
        String propName = reader.getAttributeValue(null, NAME);
        if (propName == null) {
            throw WSLogger.ROOT_LOGGER.missingPropertyNameAttribute(deploymentAspect);
        }
        String propClass = reader.getAttributeValue(null, CLASS);
        if (propClass == null) {
            throw WSLogger.ROOT_LOGGER.missingPropertyClassAttribute(deploymentAspect);
        }
        try {
            if (WSDeploymentAspectParser.isSupportedPropertyClass(propClass)) {
                Method m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                m.invoke((Object)deploymentAspect, WSDeploymentAspectParser.parseSimpleValue(reader, propClass));
                return;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)PROPERTY)) {
                        return;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    Method m;
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)MAP)) {
                        try {
                            m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                            Map map = WSDeploymentAspectParser.parseMapProperty(reader, propClass, reader.getAttributeValue(null, KEY_CLASS), reader.getAttributeValue(null, VALUE_CLASS), loader);
                            m.invoke((Object)deploymentAspect, map);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)LIST)) {
                        try {
                            m = WSDeploymentAspectParser.selectMethod(deploymentAspectClass, propName, propClass);
                            List list = WSDeploymentAspectParser.parseListProperty(reader, propClass, reader.getAttributeValue(null, ELEMENT_CLASS));
                            m.invoke((Object)deploymentAspect, list);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }

    private static Method selectMethod(Class<?> deploymentAspectClass, String propName, String propClass) throws ClassNotFoundException {
        Method[] methods;
        for (Method m : methods = deploymentAspectClass.getMethods()) {
            Class<?>[] pars;
            if (!m.getName().equals("set" + JavaUtils.capitalize((String)propName)) || (pars = m.getParameterTypes()).length != 1 || !propClass.equals(pars[0].getName()) && !pars[0].isAssignableFrom(Class.forName(propClass))) continue;
            return m;
        }
        return null;
    }

    private static boolean isSupportedPropertyClass(String propClass) {
        return String.class.getName().equals(propClass) || Boolean.class.getName().equals(propClass) || Integer.class.getName().equals(propClass) || JavaUtils.isPrimitive((String)propClass);
    }

    private static Object parseSimpleValue(XMLStreamReader reader, String propClass) throws XMLStreamException {
        if (String.class.getName().equals(propClass)) {
            return StAXUtils.elementAsString((XMLStreamReader)reader);
        }
        if (Boolean.class.getName().equals(propClass)) {
            return StAXUtils.elementAsBoolean((XMLStreamReader)reader);
        }
        if (Integer.class.getName().equals(propClass)) {
            return StAXUtils.elementAsInt((XMLStreamReader)reader);
        }
        if (Boolean.TYPE.getName().equals(propClass)) {
            return StAXUtils.elementAsBoolean((XMLStreamReader)reader);
        }
        throw WSLogger.ROOT_LOGGER.unsupportedPropertyClass(propClass);
    }

    private static List parseListProperty(XMLStreamReader reader, String propClass, String elementClass) throws XMLStreamException {
        List list = null;
        try {
            list = (List)Class.forName(propClass).newInstance();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.cannotInstantiateList(e, propClass);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)LIST)) {
                        return list;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)VALUE)) {
                        list.add(WSDeploymentAspectParser.parseSimpleValue(reader, elementClass));
                        break;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }

    private static Map parseMapProperty(XMLStreamReader reader, String propClass, String keyClass, String valueClass, ClassLoader loader) throws XMLStreamException {
        Map map = null;
        try {
            map = (Map)Class.forName(propClass, true, loader).newInstance();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.cannotInstantiateMap(e, propClass);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)MAP)) {
                        return map;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)ENTRY)) {
                        WSDeploymentAspectParser.parseMapEntry(reader, map, keyClass, valueClass);
                        break;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }

    private static void parseMapEntry(XMLStreamReader reader, Map map, String keyClass, String valueClass) throws XMLStreamException {
        boolean keyStartDone = false;
        boolean valueStartDone = false;
        Object key = null;
        Object value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)ENTRY) && keyStartDone && valueStartDone) {
                        map.put(key, value);
                        return;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedEndTag(reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)KEY)) {
                        keyStartDone = true;
                        key = WSDeploymentAspectParser.parseSimpleValue(reader, keyClass);
                        break;
                    }
                    if (StAXUtils.match((XMLStreamReader)reader, (String)NS, (String)VALUE)) {
                        valueStartDone = true;
                        value = WSDeploymentAspectParser.parseSimpleValue(reader, valueClass);
                        break;
                    }
                    throw WSLogger.ROOT_LOGGER.unexpectedElement(reader.getLocalName());
                }
            }
        }
        throw WSLogger.ROOT_LOGGER.unexpectedEndOfDocument();
    }
}

